package com.pcloud.book.pcloudkeyword.entity;

import com.pcloud.book.skill.entity.PcloudSkill;
import com.pcloud.common.entity.BaseEntity;

import java.util.ArrayList;
import java.util.List;

import com.pcloud.common.utils.string.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel("全平台关键词")
public class PcloudKeyword extends BaseEntity {

    @ApiModelProperty("类型1：精准，2模糊")
    private Integer type;

    @ApiModelProperty("方式1全部回复，2随机回复")
    private Integer method;

    @ApiModelProperty("关键词分类id")
    private Long keywordClassifyId;

    @ApiModelProperty("回复列表")
    private List<PcloudKeywordReply> pcloudKeywordReplies;

    @ApiModelProperty("名称列表")
    private List<PcloudKeywordName> pcloudKeywordNames;

    @ApiModelProperty("技能id")
    private String skillIds;

    @ApiModelProperty("技能id列表")
    private List<Long> skillIdList;

    @ApiModelProperty("技能列表")
    private List<PcloudSkill> pcloudSkillList;

    public String getSkills(List<Long> skillList){
        String skills="";
        for (int i=0;i<skillList.size() ;i++){
            if (i==0){
                skills = skillList.get(i).toString();
            } else if (i>0){
                skills = skills+"-"+skillList.get(i).toString();
            }
        }
        return skills;
    }

    public List<Long> getSkillList(String skillIds){
        List<Long> list = new ArrayList<>();
        if (StringUtil.isEmpty(skillIds)){
            return list;
        }
        String[] strings = skillIds.split("-");
        for (String str: strings){
            Long id = Long.valueOf(str);
            list.add(id);
        }
        return list;
    }
}
