package com.pcloud.book.personal.facade;

import com.pcloud.book.keywords.entity.RobotSkillDetail;
import com.pcloud.book.personal.biz.PersonalBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import io.swagger.annotations.Api;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api("个人中心")
@RestController("personalFacade")
@RequestMapping("personal")
public class PersonalFacade {

    @Autowired
    private PersonalBiz personalBiz;

    @RequestMapping(value = "getSKillRecordPage",method = RequestMethod.GET)
    public ResponseDto<PageBeanNew<RobotSkillDetail>>  getSKillRecordPage(@RequestParam("type") Integer skillType, @RequestParam String wxUserId,
                                                                          @Param("currentPage") Integer currentPage, @Param("numPerPage") Integer numPerPage){
        PageBeanNew<RobotSkillDetail> pageBeanNew = personalBiz.getSKillRecordPage(skillType,wxUserId,currentPage,numPerPage);
        return new ResponseDto<>(pageBeanNew);
    }
}
