package com.pcloud.book.personalstage.biz;

import com.pcloud.book.personalstage.dto.PersonalStageProgressDTO;
import com.pcloud.book.personalstage.entity.PersonalStageProgressMessage;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * (PersonalStageProgressMessage)表服务接口
 *
 * @author zyq
 * @since 2020-02-25 09:56:00
 */
public interface PersonalStageProgressMessageBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    PersonalStageProgressMessage getById(Long id);

    /**
     * 分页查询
     */
    List<PersonalStageProgressMessage> getProgressMessageList(Integer progressId);

    /**
     * 新增数据
     *
     * @param personalStageProgressMessage 实例对象
     * @return 主键
     */
    Long save(List<PersonalStageProgressMessage> personalStageProgressMessage);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取进度单列表
     * @return
     */
    List<PersonalStageProgressDTO> getProgressList();
}