package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageUserDao;
import com.pcloud.book.personalstage.entity.PersonalStageUser;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;


@Component("personalStageUser")
public class PersonalStageUserDaoImpl extends BaseDaoImpl<PersonalStageUser> implements PersonalStageUserDao {
    @Override
    public PersonalStageUser getLast(String wxId, String robotId, Long personalStageId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxId", wxId);
        map.put("robotId", robotId);
        map.put("personalStageId", personalStageId);
        return super.getSessionTemplate().selectOne(getStatement("getLast"), map);
    }

    @Override
    public Integer getNotKeywordSendCount(String wxId, String robotId, Long personalStageId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxId", wxId);
        map.put("robotId", robotId);
        map.put("personalStageId", personalStageId);
        return super.getSessionTemplate().selectOne(getStatement("getNotKeywordSendCount"), map);
    }

    @Override
    public void updateRequireNumber(Long personalStageUserId, String requireNumber) {
        Map<String, Object> map = new HashMap<>();
        map.put("personalStageUserId", personalStageUserId);
        map.put("requireNumber", requireNumber);
        super.getSessionTemplate().update(getStatement("updateRequireNumber"), map);
    }

    @Override
    public void updateScore(Long id, Integer score){
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("score", score);
        super.getSessionTemplate().update(getStatement("updateScore"), map);
    }

    @Override
    public void updateFusingReplyCount(Long id) {
        super.getSessionTemplate().update(getStatement("updateFusingReplyCount"), id);
    }
}
