package com.pcloud.book.recommend.biz.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.pcloud.book.recommend.dao.ResourceRecommendDao;
import com.pcloud.book.recommend.dto.RecommendServeDto;
import com.pcloud.book.recommend.entity.BookRecommend;
import com.pcloud.book.recommend.dao.BookRecommendDao;
import com.pcloud.book.recommend.biz.BookRecommendBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;

/**
 * 基于书的推荐(BookRecommend)表服务实现类
 *
 * @author makejava
 * @since 2021-10-29 15:21:58
 */
@Service("bookRecommendBiz")
public class BookRecommendBizImpl implements BookRecommendBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(BookRecommendBizImpl.class);

    @Autowired
    private BookRecommendDao bookRecommendDao;
    @Autowired
    private ResourceRecommendDao resourceRecommendDao;

    @Override
    public List<RecommendServeDto> getById(Long bookId, Long channelId, Long adviserId, Integer fromType) {
        String recommend=bookRecommendDao.getBookRecommend(bookId,channelId,adviserId,fromType);
        if(StrUtil.isBlank(recommend)){
            return null;
        }
        List<RecommendServeDto> result = getRecommendServeDtos(recommend);
        if (result == null) return null;
        return result;
    }

    private List<RecommendServeDto> getRecommendServeDtos(String recommend) {
        List<String> ids = JSONArray.parseArray(recommend, String.class);
        if(CollUtil.isEmpty(ids)){
            return null;
        }
        List<RecommendServeDto> result=new ArrayList<>();
        RecommendServeDto recommendServeDto;
        for (String id : ids) {
            recommendServeDto=new RecommendServeDto();
            Long serveId=null;
            String prefix=null;
            if(id.startsWith("AP")){
                recommendServeDto.setServeType("APP");
                prefix="AP";
            }else if(id.startsWith("PD")){
                recommendServeDto.setServeType("PRODUCT");
                prefix="PD";
            }else{
                continue;
            }
            String ap = id.replace(prefix, "");
            try {
                serveId  = Long.valueOf(ap);
            } catch (NumberFormatException e) {
                continue;
            }
            recommendServeDto.setServeId(serveId);
            result.add(recommendServeDto);
        }
        return result;
    }

    @Override
    public List<RecommendServeDto> getByServeId(Long adviserId,Long serveId, String serveType, Integer fromType) {
        String recommend=resourceRecommendDao.getServeRecommend(adviserId,serveId,serveType,fromType);
        if(StrUtil.isBlank(recommend)){
            return null;
        }
        List<RecommendServeDto> result = getRecommendServeDtos(recommend);
        if (result == null) return null;
        return result;
    }
}
