package com.pcloud.book.recommend.dao.impl;

import com.pcloud.book.recommend.entity.BookRecommend;
import com.pcloud.book.recommend.dao.BookRecommendDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 基于书的推荐(BookRecommend)表数据库访问层
 *
 * @author makejava
 * @since 2021-10-29 15:21:57
 */
@Repository("bookRecommendDaoImpl")
public class BookRecommendDaoImpl extends BaseDaoImpl<BookRecommend> implements BookRecommendDao {

    @Override
    public String getBookRecommend(Long bookId, Long channelId, Long adviserId, Integer fromType) {
        Map<String,Object> paramMap=new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("fromType",fromType);
        return super.getSessionTemplate().selectOne(getStatement("getBookRecommend"),paramMap);
    }
}