package com.pcloud.book.timecontrol.mapper;


import com.pcloud.book.timecontrol.entity.TimeControlTaskItem;
import com.pcloud.book.timecontrol.dto.ReplyMessageBaseDto;
import java.util.Date;

import com.pcloud.book.timecontrol.vo.request.TimeControlTaskItemVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("taskItemMapper")
public interface TimeControlTaskItemMapper {

    int deleteByPrimaryKey(Integer id);

    int insert(TimeControlTaskItem record);

    TimeControlTaskItem selectByPrimaryKey(Integer id);

    TimeControlTaskItem getByTaskIdAndDay(@Param("taskId") Integer taskId, @Param("startDay") Integer startDay);

    void updateTaskItem(TimeControlTaskItem timeControlTaskItem);

    List<ReplyMessageBaseDto> listTaskItemDay(Integer taskId);

    List<TimeControlTaskItem> getByItemIdList(@Param("taskItemIds") List<Integer> taskItemIds);

    Integer getTaskItemCount(@Param("taskId") Integer taskId);

    List<TimeControlTaskItem> listByTaskId(Integer taskId);

    List<TimeControlTaskItem> getByTaskId(Integer taskId);

    Date getMaxEndTime(Integer taskId);

    void deleteByTaskId(Integer taskId);

    TimeControlTaskItemVO getMonthDay(String date);

    List<TimeControlTaskItemVO> getMonthSecondDay(String date);
}
