package com.pcloud.book.book.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.pcloud.common.constant.CacheConstant;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;

/**
 * 描述 :图书常量
 *
 * @author 作者: lili
 * @version 1.0
 * @date 创建时间：2017年7月18日 上午10:02:36
 */
public class BookConstant {

    /**
     * 更新群二维码时是否同步更新群二维码素材 - 缓存开关
     */
    public static final String BOOK_UPDATE_QRCODE_MATERIAL_SWITCH = CacheConstant.BOOK + "BOOK_UPDATE_QRCODE_MATERIAL_SWITCH:";

    /**
     * 书名分词群标签缓存
     */
    public static final String BOOK_NAME_TAGS_CACHE = CacheConstant.BOOK + "BOOK_NAME_TAGS_CACHE:";

    /**
     * book_group_qrcode 数据导入 Elasticsearch 缓存 KEY
     */
    public static final String BOOK_GROUP_QRCODE_ES_INIT = CacheConstant.BOOK + "BOOK_GROUP_QRCODE_DATA_INIT:";

    /**
     * 微信小号每天拉人次数缓存前缀
     */
    public static final String WXGROUP_ADD_USER_NUM = CacheConstant.BOOK + "WXGROUP_ADD_USER_NUM:";

    /**
     * 图书基础缓存前缀名称
     */
    public static final String BOOK_CACHE = CacheConstant.BOOK + "BOOK:";

    /**
     * 图书缓存时间60分钟
     */
    public static final Integer BOOK_CACHE_SECOUND = 3600;

    /**
     * 图书基础缓存前缀名称
     */
    public static final String BOOK_ISBN_CACHE = CacheConstant.BOOK + "ISBN:";

    /**
     * 图书应用关联缓存前缀名称
     */
    public static final String BOOK_APP_CACHE = CacheConstant.BOOK + "BOOK_APP:";

    /**
     * 图书商品关联缓存前缀名称
     */
    public static final String BOOK_PRODUCT_CACHE = CacheConstant.BOOK + "BOOK_PRODUCT:";

    /**
     * 图书资源关联缓存前缀名称
     */
    public static final String BOOK_RESOURCE_CACHE = CacheConstant.BOOK + "BOOK_RESOURCE:";

    /**
     * 图书资源关联缓存前缀名称
     */
    public static final String ADVISER_BOOK_CACHE = CacheConstant.BOOK + "ADVISER_BOOK_CACHE:";

    /**
     * 图书缓存时间1天
     */
    public static final Integer BOOK_CACHE_ONE_DAY = 60 * 60 * 24;

    /**
     * 图书缓存时间1月
     */
    public static final Integer BOOK_CACHE_ONE_MONTH = 60 * 60 * 24 * 30;

    /**
     * 图书编辑状态 1已删除
     */
    public static final Integer BOOK_ADVISER_DELETE = 1;

    /**
     * 图书编辑状态 0未删除
     */
    public static final Integer BOOK_ADVISER_NO_DELETE = 0;

    /**
     * 图书应用关系 1删除
     */
    public static final Integer BOOK_APP_DELETE = 1;

    /**
     * 图书应用关系 0未删除
     */
    public static final Integer BOOK_APP_NO_DELETE = 0;

    /**
     * 主編輯
     */
    public static final Integer MAIN_ADVISER = 1;

    /**
     * 副編輯
     */
    public static final Integer VICE_ADVISER = 0;

    /**
     * 默认图书isbn
     */
    public static final String DEFAULT_BOOK_ISBN = "9787507600000";

    /**
     * 图书查询个数
     */
    public static final Integer BOOK_SELECT_COUNT = 500;

    /**
     * 主编辑
     */
    public static final Integer MAIN_EDITOR = 1;

    /**
     * 副编辑
     */
    public static final Integer NOT_MAIN_EDITOR = 0;
    /**
     * 7天
     */
    public static final Long SEVEN = 7L;
    /**
     * 15天
     */
    public static final Long FIFTEEN = 15L;
    /**
     * 30天
     */
    public static final Long THIRTY = 30L;

    public static final Random RANDOM = new Random();

    public static  final Integer zero = 0;

    /**
     * 微信群默认头像
     */
    public static final List<String> DEFAULT_HEADURL =Arrays.asList(
            "https://oss.5rs.me/oss/upload/image/jpg/fd9e019d8c6d4a5a84769d69932f32a0.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/e7fbe5cfb8e74eebad610091b2d90941.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/4b450a1c244a4c2a83e5bb83749eecd2.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/8fa48b32e4f845ee8174bcf70c4d6d1a.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5c2af3517a6941feaa278c23e85db16f.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/d8413818004b43c3af489ca6e249ae31.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/05d98267b99441f2be54d5c4b39c99e1.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a5ff33889b4945bd94f7bfc8216bc0d8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/3fb33c317d7f48df93109571957959fa.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/f0d92d9a3ef643189334514a7f2c84a6.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/349fc64b712f4fc7851450e00170dfb3.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/32ff9aded9cb4ba6b5e953478a6c9a92.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a7bddec750a847778b04105538a6ea34.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/c19b98c0b90844df946e8b2302bfaa0b.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5c10b538d3404a3f8e9fe1a1bbc951d6.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/dfcc5d6fca144e38824abf1f33cb1f56.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/25f62e182ad54372a98e91308ed7c4f5.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/984cb4309a19496f87c720f0819fc590.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a7c92e9177a446c7883aaa99925340f5.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/edf879e7224c42ff88f0a85256d464c9.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a0b43e220ccf49db8f64985c07d4c582.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/3beb0351679445b8868a74376ca640ab.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/3695698e277a47b185b5d6700bc7a6ea.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/b516878d119b44d7becd956f561539b1.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/481df9f13435481cb7586271e3c47c64.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/4b812016a41e462c96d2b5c1de18bbb1.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/b74f78f46a624949a5f44b33849545a0.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/db04c03fda80470c87f36b72e5f0d693.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/9357f804352a4631b7721c3883366f32.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/7517400597f242c99356ece0418cbb69.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/9c0d0c0613b948d19653c0554e59bf10.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/c7cafaac33ce412dbf6b54cdcb968869.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5a5efece215f44b593082fd5acb1ba6a.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a5130474001744d39a953c264b6f2b50.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/0c8b292f2f4a462a8eb15498f3134bdc.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/e52aa27710b04814ad72e26f24672c3e.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/05de1499008949cb923d9b4f069cd063.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5d029cdb3c574d2ab90cb8f621126788.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/be4cf4579c614fc6bcf6eecf768c77f8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/9d8a34ec22bb4a029b0d3bcf3d01c678.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/b225c12aea284be5916d186cc6b3527c.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/76dffe5833564acc980a52451c0f30c8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/1515fa78369d4b1b94b4833d46fad7b8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/937747a210894a06af9471b14a31473c.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/6be030a556994cb693f22a94cec4a971.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/bd71e3cf4ea74f26824007ece26d0ddf.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/56a53ea3eda347d4a89bd2ecf9aef013.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/68a2e52a89b6470ebcc2aae0ee17d476.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/04ea6a300a114807b2101ac949b7590a.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a6049fbf9bdb4c7097b80751932d4820.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/611f1fce1b894749a2a67bcb19863e89.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/4beb1075c99d4f8688208a676d236861.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/cc126b48d7ba4e4a9f13a4f891eebedf.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/c2d331e1f25a4ffeb34992712e4155c7.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/e5387066120842cd85c12ebcbfd8d93f.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5a922de5f11e4ada92fec367716a257d.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/0e093bce8d684b29b85fd6184af67ef7.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5d6a1cc42a35464293cb63b89b3271e7.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/9ad9b7af4aa840ba83485c2c9cfbc861.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/58bc326f3c374abe8a76a6edabf6c8e8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/93dbbd4882984930b40018aba95a5fc8.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/8971ad7ff7394b10a496e2a20f220811.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/63fdae8b3c7d42b59ad2caa696c759a9.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a15dd9799e044c028596fa9dc7a8a65e.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/84a635285e9e4fae930a0e542b48c17b.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5d85b6e07e094030a0851e37627961c3.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/54ad45ae8ca94dffb53599420b3934ef.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/27e014bf12c34028821703fc873b0d7b.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5ea14cca8fbc4bbcba7b5847d7db95a7.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/c4b44c4d33e74f58b25be7c1b065a3ec.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/1daf5b240f64444c9a9f723203a46d31.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/bfd05d7239174fa88c1a02fd10ddfe23.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/1f3f34a0101646b4beab8b359139f8d9.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5fca5466fde74ac3aa68282d02fbc49c.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/b07f4f25a1ea49a3b2941563e49ab98a.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/76ec59b91eb54c9cb0992bb9db554d5e.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/7cdf4f671c55463d806906b3136f488c.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/9a334914f3284b6584aa853b20637908.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/9b8b139694df41ada6af64af78361831.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a9f3dc95a7724fcc925c3ab963f66e4d.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/07794c9246474aa58b7c22dec149b102.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/033ada5f3df24cb193487ce5c325368d.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/5d545cbbea674b11a1cfa88b56e763ac.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/2d1404e4a65c4267ad07506c28c8d95e.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a0ce9a2815da4e6aa468e6384aa5073c.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a4dcee8850e0482ba3ba3b59cfd1b68f.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/4850c8f8eb2e4cf5839b375d90fd0f57.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/99ffd32e077a427bbc6871ce418b09dc.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/f1ef53d0ba934e0f965ac70d9c8b5a89.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/a927082e706446c19079971e81338c19.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/224582917734415da4ff7643737444eb.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/64514374c3784edfb3eed9501aa70fe4.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/e80bf344d2d64ac1a8e697c3304af371.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/d1ba7823193846609dc00f2c1661e693.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/84f9f400a6e645dabf99df60201c269b.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/f9790b6747d846cf8d1d1edabbae18c0.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/aff7bdad64644a6f93db729b6aee9627.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/23d89fee946040bd8b004bf3de0f3d38.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/983d05134c1e4c718f7ca541b92fa1df.jpg",
            "https://oss.5rs.me/oss/upload/image/jpg/15cf9fd35f044e65807663d52d4bd37e.jpg");

    /**
     * 随机获取指定数量头像
     * @return
     */
    public static List<String> getRandomHeadUrl(int num) {
        List<String> headUrls = Lists.newArrayList();
        for (int i = 0; i < num; i++) {
            headUrls.add(DEFAULT_HEADURL.get(RANDOM.nextInt(DEFAULT_HEADURL.size())));
        }
        return headUrls;
    }

    public enum BookKeywordAuditEnum {

        NORMAL(0),
        /**
         * 待审核
         */
        TO_AUDIT(1),
        /**
         * 审核通过
         */
        PASS_THE_AUDIT(2),
        /**
         * 拒绝审核
         */
        REFUSE_THE_AUDIT(3);

        private Integer code;

        BookKeywordAuditEnum(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    public static final Map<Integer, BookKeywordAuditEnum> AUDIT_ENUM_MAP = Maps.newHashMap();

    static {
        for (BookKeywordAuditEnum auditEnum : Lists.newArrayList(BookKeywordAuditEnum.values())) {
            AUDIT_ENUM_MAP.put(auditEnum.getCode(), auditEnum);
        }
    }

    public enum BookKeywordScopeEnum {
        /**
         * 全部
         */
        ALL(0),
        /**
         * 编辑
         */
        EDITOR(1);

        private Integer code;

        BookKeywordScopeEnum(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    public static  final Integer  REPLACE_CODE_BOOK_NAME  = 1;

    public static final String  SPECPATTEN  = "^[_`~!@#$%^&*()+=|{}':;',\\[\\].·<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]+$";

    public static final String  SPECPATTEN_1  ="^[\\[\\]❤❥웃유♋☮✌☏☢☠✔☑♚▲♪✈✞÷↑↓◆◇⊙■□△▽¿─│♥❣♂♀☿Ⓐ✍✉☣☤✘☒♛▼♫⌘☪≈←→◈◎☉★☆⊿※¡━┃" +
            "♡ღツ☼☁❅♒✎©®™Σ✪✯☭➳卐√↖↗●◐Θ◤◥︻〖〗┄┆℃℉°✿ϟ☃☂✄¢€£∞✫★½✡×↙↘○◑⊕◣◢︼【】┅┇☽☾✚〓▂▃▄▅▆▇█▉▊▋▌▍▎▏↔↕☽☾の•▸◂▴▾┈┊" +
            "①②③④⑤⑥⑦⑧⑨⑩ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ㍿▓♨♛❖♓☪✙┉┋☹☺☻تヅツッシÜϡﭢ™℠℗©®♥❤❥❣❦❧♡۵웃유ღ♋♂♀☿☼☀☁☂☄☾☽❄☃☈⊙☉℃℉❅✺ϟ☇♤♧♡♢♠♣♥♦☜☞☝✍☚" +
            "☛☟✌✽✾✿❁❃❋❀⚘☑✓✔√☐☒✗✘ㄨ✕✖✖⋆✢✣✤✥❋✦✧✩✰✪✫✬✭✮✯❂✡★✱✲✳✴✵✶✷✸✹✺✻✼❄❅❆❇❈❉❊†☨✞✝☥☦☓☩☯☧☬☸✡♁✙♆。，、＇：∶" +
            "；?‘’“”〝〞ˆˇ﹕︰﹔﹖﹑•¨….¸;！´？！～—ˉ｜‖＂〃｀@﹫¡¿﹏﹋﹌︴々﹟#﹩$﹠&﹪%*﹡﹢﹦﹤‐￣¯―﹨ˆ˜﹍﹎+=<＿_-\\ˇ~﹉﹊（）〈〉‹›﹛﹜" +
            "『』〖〗［］《》〔〕{}「」【】︵︷︿︹︽_﹁﹃︻︶︸﹀︺︾ˉ﹂﹄︼☩☨☦✞✛✜✝✙✠✚†‡◉○◌◍◎●◐◑◒◓◔◕◖◗❂☢⊗⊙◘◙◍⅟½⅓⅕⅙⅛⅔⅖⅚⅜¾⅗⅝⅞⅘≂" +
            "≃≄≅≆≇≈≉≊≋≌≍≎≏≐≑≒≓≔≕≖≗≘≙≚≛≜≝≞≟≠≡≢≣≤≥≦≧≨≩⊰⊱⋛⋚∫∬∭∮∯∰∱∲∳%℅‰‱㊣㊎㊍㊌㊋㊏㊐㊊㊚㊛㊤㊥㊦㊧㊨㊒" +
            "㊞㊑㊒㊓㊔㊕㊖㊗㊘㊜㊝㊟㊠㊡㊢㊩㊪㊫㊬㊭㊮㊯㊰㊙㉿囍♔♕♖♗♘♙♚♛♜♝♞♟ℂℍℕℙℚℝℤℬℰℯℱℊℋℎℐℒℓℳℴ℘ℛℭ℮ℌℑℜℨ♪♫♩♬" +
            "♭♮♯°øⒶ☮✌☪✡☭✯卐✐✎✏✑✒✍✉✁✂✃✄✆✉☎☏➟➡➢➣➤➥➦➧➨➚➘➙➛➜➝➞➸♐➲➳⏎➴➵➶➷➸➹➺➻➼➽←↑→↓↔↕↖↗↘" +
            "↙↚↛↜↝↞↟↠↡↢↣↤↥↦↧↨➫➬➩➪➭➮➯➱↩↪↫↬↭↮↯↰↱↲↳↴↵↶↷↸↹↺↻↼↽↾↿⇀⇁⇂⇃⇄⇅⇆⇇⇈⇉⇊⇋⇌⇍⇎⇏⇐⇑⇒⇓⇔⇕⇖⇗⇘⇙⇚⇛⇜⇝⇞" +
            "⇟⇠⇡⇢⇣⇤⇥⇦⇧⇨⇩⇪➀➁➂➃➄➅➆➇➈➉➊➋➌➍➎➏➐➑➒➓㊀㊁㊂㊃㊄㊅㊆㊇㊈㊉ⒶⒷⒸⒹⒺⒻⒼⒽⒾⒿⓀⓁⓂⓃⓄⓅⓆⓇⓈⓉⓊⓋⓌⓍⓎⓏⓐⓑⓒⓓⓔⓕⓖⓗⓘ" +
            "ⓙⓚⓛⓜⓝⓞⓟⓠⓡⓢⓣⓤⓥⓦⓧⓨⓩ⒜⒝⒞⒟⒠⒡⒢⒣⒤⒥⒦⒧⒨⒩⒪⒫⒬⒭⒮⒯⒰⒱⒲⒳⒴⒵ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩⅪⅫⅬⅭⅮⅯⅰⅱⅲⅳⅴⅵⅶⅷⅸ" +
            "ⅹⅺⅻⅼⅽⅾⅿ┌┍┎┏┐┑┒┓└┕┖┗┘┙┚┛├┝┞┟┠┡┢┣┤┥┦┧┨┩┪┫┬┭┮┯┰┱┲┳┴┵┶┷┸┹┺┻┼┽┾┿╀╁╂╃╄╅╆╇╈╉╊╋╌╍╎╏═║╒╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡╢╣╤╥╦╧╨╩╪╫╬◤◥◄►▶◀◣◢▲▼◥▸◂" +
            "▴▾△▽▷◁⊿▻◅▵▿▹◃❏❐❑❒▀▁▂▃▄▅▆▇▉▊▋█▌▍▎▏▐░▒▓▔▕■□▢▣▤▥▦▧▨▩▪▫▬▭▮▯㋀㋁㋂㋃㋄㋅㋆㋇㋈㋉㋊㋋]+$";

    public static final String  TIME_CONTROL_KEY = "lgsc";

    public static final String  TIME_CONTROL_UPDATE_SEND = "TIME_CONTROL_UPDATE_SEND";

    public static final String  TIME_CONTROL_SEND = "TIME_CONTROL_SEND_";

    public static final String DEFAULT_COVER_PIC="https://oss.5rs.me/oss/uploadfe/jpg/b10f42694d17429fe9ebd8dfd85704e0.jpg";


    public static final Integer MAX_NEWS_COUNT = 3;

    public static final Integer MAX_NEWS_COUNT_GROUP = 5;

    public static final String APP_PRODUCT = "APP/PRODUCT";

    public static final String[] APPANDPRODUCT = {"APP","PRODUCT"};

    public static final Long[] PROD_ADVISERS = new Long[]{1362L};

    public static final Long[] UAT_ADVISERS = new Long[]{12829L};

    public static final Long[] TEST_ADVISERS = new Long[]{1404L, 1001195L};

    public static final String HANZI = "哈或";

    public static final String countryRegionCode = "100000";

    public static final Integer countryAreaCode = 0;

    public static final String NO_RESOURCE_REMIND = "no_resource_remind";

    public static final Integer  HOME_BOOK_PAGE = 3;

    public static final String DEFAULT_NEWS_PIC="https://oss.5rs.me/oss/uploadfe/jpg/c469a21a758b79e00783fe3a70a605c5.jpg";
    /**
     * 群二维码永久图文素材，html 源代码
     */
    public static final String GROUP_QRCODE_NEWS_MATERIAL_HTML = "<div style='margin:10px 0;box-sizing: border-box;'><header style='display: flex;padding:0 20px;'><img style='width: 60px;height: 60px;'src='${groupHeadImg}'alt=''><div style='display: flex;flex: 1;align-items: center;margin-left:10px;color:#000;font-size: 16px;font-weight: bold;'>${groupName}</div></header><div style='margin:55px auto 32px;width: 275px;height: 255px;'><div style='width: 275px;height: 255px;background-color: #ffffff;border-radius: 6px;border: solid 1px #66c84f'><div style='margin-top:-16px;margin-left:53px;width: 168px;height: 32px;line-height: 32px;text-align: center; font-size: 14px;color: #ffffff; background-color: #66c84f;border-radius: 6px;'>长按识别下面二维码</div><div style='height: 23px;display: block;text-align: center;margin: 10px auto;letter-spacing: 6px;'>\uD83D\uDC47\uD83D\uDC47\uD83D\uDC47</div><div style='width: 172px;height:172px;display: block;margin: 0 auto;'><img class='qrcode'src='${qrcodeUrl}'alt=''></div></div></div></div>";

    public static final String BOOK_CITY_MAP = CacheConstant.BOOK + "BOOK_CITY_MAP";

    public static final Integer DEFAULT_DAY_TIMEOUT = 24 * 60 * 60;
}
