package com.pcloud.book.book.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 书刊基金信息类
 */
public class BookFundInfoDto implements Serializable {
    /**
     * 书刊ID
     */
    @ApiModelProperty(value = "书刊ID")
    private Long bookId;
    /**
     * 书刊基金ID
     */
    @ApiModelProperty(value = "书刊基金ID")
    private Long bookFundId;
    /**
     * 基金名字
     */
    @ApiModelProperty(value = "基金名字")
    private String fundName;
    /**
     * 合同编号
     */
    @ApiModelProperty(value = "合同编号")
    private String contractNo;
    /**
     * 批次号
     */
    @ApiModelProperty(value = "批次号")
    private String batchNumber;
    /**
     * 代理模式
     */
    @ApiModelProperty(value = "代理模式")
    private Integer proxyMode;
    /**
     * 是否为受让方
     */
    @ApiModelProperty(value = "是否为受让方")
    private Integer isTransferor;
    /**
     * 转让方名字
     */
    @ApiModelProperty(value = "转让方名字")
    private String transferor;

    /**
     * 购买金额
     */
    @ApiModelProperty(value = "购买金额")
    private BigDecimal purchaseMoney;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    public String getTransferor() {
        return transferor;
    }

    public void setTransferor(String transferor) {
        this.transferor = transferor;
    }

    public Integer getIsTransferor() {
        return isTransferor;
    }

    public void setIsTransferor(Integer isTransferor) {
        this.isTransferor = isTransferor;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getBookFundId() {
        return bookFundId;
    }

    public void setBookFundId(Long bookFundId) {
        this.bookFundId = bookFundId;
    }

    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public String getBatchNumber() {
        return batchNumber;
    }

    public void setBatchNumber(String batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Integer getProxyMode() {
        return proxyMode;
    }

    public void setProxyMode(Integer proxyMode) {
        this.proxyMode = proxyMode;
    }

    public BigDecimal getPurchaseMoney() { return purchaseMoney; }

    public void setPurchaseMoney(BigDecimal purchaseMoney) { this.purchaseMoney = purchaseMoney; }

    public Date getStartTime() { return startTime; }

    public void setStartTime(Date startTime) { this.startTime = startTime; }

    public Date getEndTime() { return endTime; }

    public void setEndTime(Date endTime) { this.endTime = endTime; }

    @Override
    public String toString() {
        return "BookFundInfoDto{" +
                "bookId=" + bookId +
                ", bookFundId=" + bookFundId +
                ", fundName='" + fundName + '\'' +
                ", contractNo='" + contractNo + '\'' +
                ", batchNumber='" + batchNumber + '\'' +
                ", proxyMode=" + proxyMode +
                ", isTransferor=" + isTransferor +
                ", transferor='" + transferor + '\'' +
                ", purchaseMoney=" + purchaseMoney +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                '}';
    }
}
