package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *   图书冻结内部接口
 * @author lili
 * @date 2018/1/18 19:15
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookFreezeServiceCloud", path = "book/v1.0/bookFreezeService")
@Api(description = "图书冻结内部服务")
public interface BookFreezeService {

    @ApiOperation(value = "判断书刊是否被冻结", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/isFreeze", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Boolean>> isFreeze(@RequestParam(value = "bookId", required = false) Long bookId) throws BizException;

    @ApiOperation(value = "获取冻结信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getById", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookFreezeDto>> getById(@RequestParam(value = "bookId", required = false) Long bookId) throws BizException;
}
