package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingGroupTagDao;
import com.pcloud.book.advertising.entity.AdvertisingGroupTag;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：群标记广告主
 * @作者：zhuyajie
 * @创建时间：14:53 2019/8/21
 * @版本：1.0
 */
@Component("advertisingGroupTagDao")
public class AdvertisingGroupTagDaoImpl extends BaseDaoImpl<AdvertisingGroupTag> implements AdvertisingGroupTagDao {

    @Override
    public void deleteByBrandId(Long brandId) {
        getSessionTemplate().delete(getStatement("deleteByBrandId"), brandId);
    }

    @Override
    public List<Long> getBookIdsByBrandId(Long brandId) {
        return getSessionTemplate().selectList(getStatement("getBookIdsByBrandId"), brandId);
    }

    @Override
    public void deleteByGroupQrcodeId(Long groupQrcodeId) {
        getSessionTemplate().delete(getStatement("deleteByGroupQrcodeId"), groupQrcodeId);
    }

    @Override
    public List<Long> getGroupQrcodeIdsByBrandId(Long brandId) {
        return getSessionTemplate().selectList(getStatement("getGroupQrcodeIdsByBrandId"), brandId);
    }

    @Override
    public void deleteByBook(List<Long> bookIds, Long brandId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookIds", bookIds);
        map.put("brandId", brandId);
        getSessionTemplate().delete(getStatement("deleteByBook"), map);
    }

    @Override
    public List<String> getTagWxGroupIdsByBrandId(Long brandId) {
        return getSessionTemplate().selectList(getStatement("getTagWxGroupIdsByBrandId"), brandId);
    }

    @Override
    public List<Long> getBrandIdsByBookId(Long bookId) {
        return getSessionTemplate().selectList(getStatement("getBrandIdsByBookId"), bookId);
    }

    @Override
    public List<Long> getBrandIdsByWxGroupId(String wxGroupId) {
        return getSessionTemplate().selectList(getStatement("getBrandIdsByWxGroupId"), wxGroupId);
    }

    @Override
    public void updateId(Long masterId, Long brandId) {
        Map<String, Object> map = new HashMap<>();
        map.put("masterId", masterId);
        map.put("brandId", brandId);
        getSessionTemplate().update(getStatement("updateId"), map);
    }
}
