package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

/**
 * 报名记录
 */
public class AdvertisingBmRegister extends BaseEntity{

    /**
     *用户id
     */
    private Long userId;
    /**
     *广告id
     */
    private Long adId;
    /**
     *用户昵称
     */
    private String nickName;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 报名选项信息
     */
    private List<AdvertisingBmRegisterItem> bmRegisterItemList;
    /**
     * 群二维码id
     */
    private Long qrcodeId;

    /**
     * 二维码ID
     */
    private Long sceneId;

    /**
     * 编辑ID
     */
    private Long adviserId;

    /**
     * 出版社ID
     */
    private Long agentId;

    /**
     * 运营ID
     */
    private Long channelId;

    /**
     * 公众号ID
     */
    private Long officialAccountId;

    /**
     *来源类型
     */
    private String fromType;

    /**
     * 来源ID
     */
    private Long fromId;
    /**
     * 书刊ID
     */
    private Long bookId;
    /**
     * 创建日期
     */
    private Date createDay;

    /**
     * 创建月份
     */
    private String createMonth;
    /**
     * 社群码ID
     */
    private Long bookGroupId;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName == null ? null : nickName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<AdvertisingBmRegisterItem> getBmRegisterItemList() {
        return bmRegisterItemList;
    }

    public void setBmRegisterItemList(List<AdvertisingBmRegisterItem> bmRegisterItemList) {
        this.bmRegisterItemList = bmRegisterItemList;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getOfficialAccountId() {
        return officialAccountId;
    }

    public void setOfficialAccountId(Long officialAccountId) {
        this.officialAccountId = officialAccountId;
    }

    public String getFromType() {
        return fromType;
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public Long getFromId() {
        return fromId;
    }

    public void setFromId(Long fromId) {
        this.fromId = fromId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Date getCreateDay() {
        return createDay;
    }

    public void setCreateDay(Date createDay) {
        this.createDay = createDay;
    }

    public String getCreateMonth() {
        return createMonth;
    }

    public void setCreateMonth(String createMonth) {
        this.createMonth = createMonth;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    @Override
    public String toString() {
        return "AdvertisingBmRegister{" +
                "userId=" + userId +
                ", adId=" + adId +
                ", nickName='" + nickName + '\'' +
                ", createTime=" + createTime +
                ", bmRegisterItemList=" + bmRegisterItemList +
                ", qrcodeId=" + qrcodeId +
                ", sceneId=" + sceneId +
                ", adviserId=" + adviserId +
                ", agentId=" + agentId +
                ", channelId=" + channelId +
                ", officialAccountId=" + officialAccountId +
                ", fromType='" + fromType + '\'' +
                ", fromId=" + fromId +
                ", bookId=" + bookId +
                ", createDay=" + createDay +
                ", createMonth='" + createMonth + '\'' +
                ", bookGroupId=" + bookGroupId +
                '}';
    }
}