package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.dao.AppletLinkClickDao;
import com.pcloud.book.applet.dto.ExportClickDTO;
import com.pcloud.book.applet.entity.AppletNewsServe;
import com.pcloud.book.applet.dao.AppletNewsServeDao;
import com.pcloud.book.applet.biz.AppletNewsServeBiz;
import com.pcloud.book.applet.enums.SourceTypeEnum;
import com.pcloud.book.consumer.common.ExportConsr;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * (AppletNewsServe)表服务实现类
 *
 * @author makejava
 * @since 2020-06-30 16:56:08
 */
@Service("appletNewsServeBiz")
public class AppletNewsServeBizImpl implements AppletNewsServeBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletNewsServeBizImpl.class);

    @Autowired
    private AppletNewsServeDao appletNewsServeDao;
    @Autowired
    private AppletLinkClickDao appletLinkClickDao;
    @Autowired
    private ExportConsr exportConsr;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletNewsServe getById(Long id) {
        return appletNewsServeDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletNewsServeDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletNewsServe appletNewsServe) {
        appletNewsServeDao.insert(appletNewsServe);
        return appletNewsServe.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletNewsServe appletNewsServe) {
        if(appletNewsServe == null || !NumberUtil.isNumber(appletNewsServe.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        appletNewsServeDao.update(appletNewsServe);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletNewsServeDao.deleteById(id);
    }

    @Override
    public Map<String, Object> exportClickCountExcel(Integer count, String date, Integer sourceType) {
        List<ExportClickDTO> exportClickDTOS = new ArrayList<>();
        String excelUrl = null;
        Date date4Query = DateUtils.getDateByStr(date);
        Map<String, Object> result = new HashMap<>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (Objects.equals(SourceTypeEnum.NEWS.value, sourceType)) {
            exportClickDTOS = appletLinkClickDao.getNews(count, date);
            String fileName ="资讯点击量top50-研发-" + simpleDateFormat.format(date4Query);
            excelUrl =  getExcelUrl4News(exportClickDTOS, fileName);
            result.put("fileUrl", excelUrl);
            result.put("fileName", fileName);
            return result;
        } else if (Objects.equals(SourceTypeEnum.THIRD_GROUP.value, sourceType)) {
            exportClickDTOS = appletLinkClickDao.getThirdGroup(count, date);
            String fileName ="第三方群点击量top50-研发-" + simpleDateFormat.format(date4Query);
            excelUrl =  getExcelUrl4Group(exportClickDTOS, fileName);
            result.put("fileUrl", excelUrl);
            result.put("fileName", fileName);
            return result;
        } else if (Objects.equals(SourceTypeEnum.NORMAL_GROUP.value, sourceType)) {
            exportClickDTOS = appletLinkClickDao.getNormalGroup(count, date);
            String fileName ="群分类点击量top50-研发-" + simpleDateFormat.format(date4Query);
            excelUrl =  getExcelUrl4Group(exportClickDTOS, fileName);
            result.put("fileUrl", excelUrl);
            result.put("fileName", fileName);
            return result;
        }
        return  new HashMap<>();
    }

    private String getExcelUrl4Group(List<ExportClickDTO> exportClickDTOS, String fileName) {
        // 字段名
        String[] rowsName = {"资源id", "点击量", "群名称"};
        List<Object[]> dataList = new ArrayList<>();
        Object[] objs;
        for (int i = 0; i < exportClickDTOS.size(); i++) {
            ExportClickDTO exportClickDTO = exportClickDTOS.get(i);
            objs = new Object[rowsName.length];
            objs[0] = exportClickDTO.getId();
            objs[1] = exportClickDTO.getClickCount();
            objs[2] = exportClickDTO.getResourceName();
            dataList.add(objs);
        }
        String fileUrl = exportConsr.exportExcel(fileName, rowsName, dataList);
        return fileUrl;
    }

    private String getExcelUrl4News(List<ExportClickDTO> exportClickDTOS, String fileName) {
        // 字段名
        String[] rowsName = {"资源id", "点击量", "资讯名称", "资讯来源", "权益类型"};
        List<Object[]> dataList = new ArrayList<>();
        Object[] objs;
        for (int i = 0; i < exportClickDTOS.size(); i++) {
            ExportClickDTO exportClickDTO = exportClickDTOS.get(i);
            objs = new Object[rowsName.length];
            objs[0] = exportClickDTO.getId();
            objs[1] = exportClickDTO.getClickCount();
            objs[2] = exportClickDTO.getResourceName();
            objs[3] = exportClickDTO.getSource();
            objs[4] = exportClickDTO.getRightsSettingName();
            dataList.add(objs);
        }
        String fileUrl = exportConsr.exportExcel(fileName, rowsName, dataList);
        return fileUrl;
    }
}