package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * @ClassName com.pcloud.book.applet.dto.AppletBookClassifyDTO
 * @Author zhuyajie
 * @Description 小程序书刊分类
 * @Date 2020/5/15 16:17
 * @Version 1.0
 **/
@Data
public class AppletBookClassifyDTO extends BaseDto{
    /**
     * 分类id
     */
    private Long id;
    /**
     * 分类
     */
    private String classify;
    /**
     * 分类名称
     */
    private String classifyName;
    /**
     * 排序值
     */
    private Integer seq;
    /**
     * 图标
     */
    private String pic;
    /**
     * 客户端是否展示
     */
    private Boolean showState;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 客户端标签
     */
    private List<AppletLabelDTO> userLabelDTOS;
}
