package com.pcloud.book.applet.dto;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

@Data
@ApiModel("第三方资源")
public class AppletThirdResourcesDTO extends BaseDto {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("咨询id")
    private Long fromId;

    @ApiModelProperty("第三方资源编号")
    private String number;

    @ApiModelProperty("类型   0：小程序， 1：链接")
    private Long type;

    @ApiModelProperty("第三方资源名称")
    private String name;

    @ApiModelProperty("小程序id")
    private String appletsId;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("宣传图片")
    private String resourceImgUrl;

    @ApiModelProperty("链接")
    private String url;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人")
    private Long creator;

    @ApiModelProperty("修改人")
    private Long updator;

    @ApiModelProperty("点击次数")
    private Integer clickCount;

    @ApiModelProperty("点击量pv/uv")
    private String clickPVUV;

    @ApiModelProperty("浏览量pv/uv")
    private String browsePVUV;

    private String newsIds;

    private String newsNumber;

    @ApiModelProperty("配置点")
    private String[] configPointList;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date createTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date updateTime;

    @ApiModelProperty("第三方资源路径 默认0：客服窗口  1：公众号文章素材")
    private Integer routeCode;

    @ApiModelProperty("引导语，限制30字符")
    @Length(max = 30, message = "引导语最大长度未30个字符")
    private String guide;

    @ApiModelProperty("文章素材地址")
    private String materialUrl;

    private List<AppletChartDateDTO> clickList;

    private List<AppletChartDateDTO> browseList;

}

