package com.pcloud.book.book.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 书刊标签
 */
@Data
@ApiModel("书刊标签")
public class BookLabelVO extends BaseDto {

    @ApiModelProperty("标签id")
    private Long labelId;

    @ApiModelProperty("审核状态（0待审核1通过2修改入库3未通过）")
    private Integer auditState;

    @ApiModelProperty("标签名称")
    private String name;

    @ApiModelProperty("标签类型")
    private Integer type;

    @ApiModelProperty("排序值")
    private Integer seq;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("申请说明")
    private String remark;

    @ApiModelProperty("申请人id")
    private Long createUser;

    @ApiModelProperty("编辑名称")
    private String adviserName;

    @ApiModelProperty("出版社")
    private String agentName;

    @ApiModelProperty("编辑手机号")
    private String phoneNum;
}
