package com.pcloud.book.consumer.wechat;


import cn.hutool.core.collection.CollUtil;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.wechat.service.QrcodeService;
import com.pcloud.wechatgroup.group.dto.ESGroupBookQrcodeDTO;
import com.pcloud.wechatgroup.group.service.GroupMemberService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Slf4j
@Component("wechatConsr")
public class WechatConsr {

    @Autowired
    private QrcodeService qrcodeService;
    @Autowired
    private GroupMemberService groupMemberService;

    @ParamLog("生成小程序二维码")
    public String create4MiniApp(Long officialAccountId, String scene, Integer width, String page){
        String url="";
        try {
           url = ResponseHandleUtil.parseResponse(qrcodeService.create4MiniApp(officialAccountId, scene, width, page),String.class);

        }catch (Exception e){
            log.error("qrcodeService.create4MiniApp调用失败"+e.getMessage(),e);
        }
        return url;
    }


    public Map<String, ESGroupBookQrcodeDTO> aggGroupMemberUser(List<String> wxGroupIds) {
        log.info("WechatConsr.aggGroupMemberUser 获取群成员城市及性别信息 wxGroupIds:{}", wxGroupIds);
        Map<String, ESGroupBookQrcodeDTO> map = CollUtil.newHashMap(0);
        try {
            map = ResponseHandleUtil.parseMap(groupMemberService.aggGroupMemberUser(wxGroupIds), String.class, ESGroupBookQrcodeDTO.class);
        } catch (Exception e) {
            log.error("WechatConsr.aggGroupMemberUser 获取群成员城市及性别信息失败！", e);
        }
        return map;
    }
}
