package com.pcloud.book.cultivate.dao.impl;

import com.pcloud.book.cultivate.dao.CultivateDao;
import com.pcloud.book.cultivate.entity.Cultivate;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("cultivateDao")
public class CultivateDaoImpl extends BaseDaoImpl<Cultivate> implements CultivateDao {
    @Override
    public Cultivate getByWechatUserId(Long wechatUserId) {
        return  super.getSqlSession().selectOne(getStatement("getByWechatUserId"),wechatUserId);
    }

    @Override
    public List<Cultivate> getAllOrderByStar() {
        return getSessionTemplate().selectList(getStatement("getAllOrderByStar"));
    }

    @Override
    public void updateIsHome(Integer isHome, Long cultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("isHome",isHome);
        map.put("cultivateId",cultivateId);
        super.getSessionTemplate().update(getStatement("updateIsHome"),map);
    }

    @Override
    public List<Cultivate> getRandomUserId(Long cultivateId,Long friendCultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        map.put("friendCultivateId",friendCultivateId);
        return super.getSessionTemplate().selectList(getStatement("getRandomUserId"),map);
    }

    @Override
    public List<Cultivate> getByCultivateIds(List<Long> cultivateIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateIds",cultivateIds);
        return super.getSessionTemplate().selectList(getStatement("getByCultivateIds"),map);
    }
}
