package com.pcloud.book.group.dto;

import com.pcloud.common.vo.BaseVO;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName: AgentStatisticsInfoDTO
 * @Description: 出版社数据统计DTO
 * @Auther: lihao
 * @Date: 2019/11/14 16:16
 */
public class AgentStatisticsInfoDTO extends BaseVO {

    @ApiModelProperty("出版社ID")
    private Long agentId;

    @ApiModelProperty("出版社名称")
    private String agentName;

    @ApiModelProperty("个人号社群书数量")
    private Integer groupBookCount;

    @ApiModelProperty("定制个人号数量")
    private Integer robotCount;

    @ApiModelProperty("已发消息数量")
    private Integer sendMsgCount;

    @ApiModelProperty("是否是定制出版社")
    private Boolean isSpecial;

    @Override
    public String toString() {
        return "AgentStatisticsInfoDTO{" +
                "agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", groupBookCount=" + groupBookCount +
                ", robotCount=" + robotCount +
                ", sendMsgCount=" + sendMsgCount +
                ", isSpecial=" + isSpecial +
                '}';
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Integer getGroupBookCount() {
        return groupBookCount;
    }

    public void setGroupBookCount(Integer groupBookCount) {
        this.groupBookCount = groupBookCount;
    }

    public Integer getRobotCount() {
        return robotCount;
    }

    public void setRobotCount(Integer robotCount) {
        this.robotCount = robotCount;
    }

    public Integer getSendMsgCount() {
        return sendMsgCount;
    }

    public void setSendMsgCount(Integer sendMsgCount) {
        this.sendMsgCount = sendMsgCount;
    }

    public Boolean getSpecial() {
        return isSpecial;
    }

    public void setSpecial(Boolean special) {
        isSpecial = special;
    }
}
