package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WechatMessageDTO implements Serializable {

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("具体类型")
    private String fromType;

    @ApiModelProperty("来源标识")
    private Long fromId;

    @ApiModelProperty("封面图")
    private String coverImg;

    @ApiModelProperty("宣传图")
    private String posterPicUrl;

    @ApiModelProperty("跳转链接")
    private String url;

    @ApiModelProperty("短名称")
    private String shortName;

    @ApiModelProperty("服务引导语")
    private String serviceLead;

    @ApiModelProperty("类型（商品或应用）")
    private String typeCode;

    @ApiModelProperty("图片url")
    private String picUrl;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("是否开启授权")
    private Boolean isOpen = false;

    @ApiModelProperty("是否辅导")
    private Boolean isParentCoach = false;


    public Boolean getParentCoach() {
        return isParentCoach;
    }

    public void setParentCoach(Boolean parentCoach) {
        isParentCoach = parentCoach;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFromType() {
        return fromType;
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public Long getFromId() {
        return fromId;
    }

    public void setFromId(Long fromId) {
        this.fromId = fromId;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public String getPosterPicUrl() {
        return posterPicUrl;
    }

    public void setPosterPicUrl(String posterPicUrl) {
        this.posterPicUrl = posterPicUrl;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Boolean getOpen() {
        return isOpen;
    }

    public void setOpen(Boolean open) {
        isOpen = open;
    }

    public String getServiceLead() {
        return serviceLead;
    }

    public void setServiceLead(String serviceLead) {
        this.serviceLead = serviceLead;
    }

    @Override
    public String toString() {
        return "WechatMessageVO{" +
                "title='" + title + '\'' +
                ", fromType='" + fromType + '\'' +
                ", fromId=" + fromId +
                ", coverImg='" + coverImg + '\'' +
                ", posterPicUrl='" + posterPicUrl + '\'' +
                ", url='" + url + '\'' +
                ", shortName='" + shortName + '\'' +
                ", serviceLead='" + serviceLead + '\'' +
                ", typeCode='" + typeCode + '\'' +
                ", picUrl='" + picUrl + '\'' +
                ", isOpen=" + isOpen +
                '}';
    }
}
