package com.pcloud.book.keywords.biz;

import com.pcloud.book.group.dto.PushAddUserMessageDTO;
import com.pcloud.book.keywords.vo.GuideVO;
import com.pcloud.book.keywords.vo.ReplyMessageVO;
import com.pcloud.book.keywords.vo.SetGuideVO;
import com.pcloud.book.keywords.vo.UpdateGuideVO;
import com.pcloud.wechatgroup.message.dto.AgreeAddUserDTO;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/23 15:46
 */
public interface BookGuideBiz {

    /**
     * 同意加好友发送欢迎语
     */
    void sendGuide(AgreeAddUserDTO agreeAddUserDTO);
    /**
     * @Author:lili
     * @Desr:新增欢迎语
     * @Date:2019/4/23 15:50
     */
    void insertGuide(SetGuideVO setGuideVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:更新欢迎语
     * @Date:2019/4/23 15:50
     */
    void updateGuide(UpdateGuideVO updateGuideVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:根据社群码获取欢迎语
     * @Date:2019/4/23 15:50
     */
    GuideVO getGuideByBookGroup(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:根据分类获取欢迎语
     * @Date:2019/4/23 15:51
     */
    GuideVO getGuideByClassify(Long classifyId);

    /**
     * @Author:lili
     * @Desr: 推送欢迎语消息
     * @Date:2019/5/5 11:22
     */
    void sendGuideMessage(PushAddUserMessageDTO pushAddUserMessageDTO);

    Map<String, Object> getGuideMessage(String weixinGroupId, String wexinGroupName);

    void sendGuideNew(AgreeAddUserDTO agreeAddUserDTO);
}
