package com.pcloud.book.mq.topic;

import com.alibaba.fastjson.JSON;
import com.pcloud.book.book.biz.BookBiz;
import com.pcloud.book.book.dto.CreateBookVO;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RabbitListener(queues = MQTopicConumer.ERP_AUTO_CREATE_BOOK)
public class ErpCreateBookListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(ErpCreateBookListener.class);

    @Autowired
    private BookBiz bookBiz;

    /**
     * 接收erp自动创建书刊
     */
    @ParamLog("接收erp自动创建书刊")
    @RabbitHandler
    public void onMessage(String json) throws BizException {
        try {
            List<CreateBookVO> createBookVOList=new ArrayList<>();
            if(StringUtil.isNotBlank(json)) {
                createBookVOList = JSON.parseArray(json, CreateBookVO.class);
            }
            LOGGER.error("接收erp自动创建书刊信息" + createBookVOList);
            if (ListUtils.isEmpty(createBookVOList))
                return;
            bookBiz.batchCreateBook4ErpNew(createBookVOList);
        } catch (Exception e) {
            LOGGER.error("接收erp自动创建书刊失败" + e.getMessage(), e);
        }
    }
}
