package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsNowItemDao;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/19 17:44
 **/
@Component("rightsNowItemDao")
public class RightsNowItemDaoImpl  extends BaseDaoImpl<RightsNowItem> implements RightsNowItemDao {
    @Override
    public Integer batchInsert(List<RightsNowItem> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"),list);
    }

    @Override
    public void deleteByRightsSettingId(Long rightsSettingId) {
        super.getSqlSession().delete(getStatement("deleteByRightsSettingId"),rightsSettingId);
    }

    @Override
    public List<RightsNowItem> getListByRightsSettingId(Long rightsSettingId,List<Integer> types) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("types",types);
        return super.getSqlSession().selectList(getStatement("getListByRightsSettingId"),map);
    }

    @Override
    public List<RightsNowItem> getGiftCouponListByRightsSettingId(Long rightsSettingId) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        return super.getSqlSession().selectList(getStatement("getGiftCouponListByRightsSettingId"),map);
    }

    @Override
    public List<RightsNowItem> getListByGroupIds(List<Long> groupIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("groupIds",groupIds);
        return super.getSqlSession().selectList(getStatement("getListByGroupIds"),map);
    }

    @Override
    public List<RightsNowItem> getListByRightsSettingTitleId(Long rightsSettingTitleId, List<Integer> types) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingTitleId",rightsSettingTitleId);
        map.put("types",types);
        return super.getSqlSession().selectList(getStatement("getListByRightsSettingTitleId"),map);
    }

    @Override
    public List<RightsNowItem> getGiftCouponListByRightsSettingTitleId(Long rightsSettingTitleId) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingTitleId",rightsSettingTitleId);
        return super.getSqlSession().selectList(getStatement("getGiftCouponListByRightsSettingTitleId"),map);
    }

    @Override
    public List<Long> getAdviserGroupIds(List<Long> ids) {
        return super.getSqlSession().selectList(getStatement("getAdviserGroupIds"), ids);
    }

    @Override
    public List<Long> getActivityGroupIds(List<Long> ids) {
        return super.getSqlSession().selectList(getStatement("getActivityGroupIds"), ids);
    }

    @Override
    public void deleteInvalidNews(List<Long> newsIds) {
        getSqlSession().delete(getStatement("deleteInvalidNews"), newsIds);
    }

    @Override
    public List<RightsNowItem> getByNewsIds(List<Long> newsIds) {
        return getSqlSession().selectList(getStatement("getByNewsIds"), newsIds);
    }

    @Override
    public List<RightsNowItem> getByActivityGroupIds(List<Long> activityIds) {
        return getSessionTemplate().selectList(getStatement("getByActivityGroupIds"), activityIds);
    }

    @Override
    public void deleteInvalidActivityGroups(List<Long> activityIds) {
        getSessionTemplate().delete(getStatement("deleteInvalidActivityGroups"), activityIds);

    }
}
