/**
 * 
 */
package com.pcloud.book.book.dao;

import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.book.book.entity.BookApp;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：书籍应用数据访问层接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:56:09 @版本：1.0
 */
public interface BookAppDao extends BaseDao<BookApp> {

	/**
	 * 删除应用关联关系
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	public long deleteByBook(Long bookId);

	/**
	 * 批量删除应用关联关系
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	public long deleteByBooks(List<Long> bookIds);

	/**
	 * 获取单个书籍和应用关联关系
	 * 
	 * @param bookApp
	 *            书籍关联应用实体
	 * @return
	 */
	public List<BookAppDto> listBaseById(BookApp bookApp);

	/**
	 * 获取书籍关联的应用
	 * 
	 * @param bookApp
	 *            书籍关联应用实体
	 * @return
	 */
	public List<BookAppDto> getListById(BookApp bookApp);

	/**
	 * 根据书籍和渠道删除书籍应用关联信息
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap);

	/**
	 * 获取关联基本信息
	 * 
	 * @param bookAppId
	 *            书籍关联应用标识
	 * @return
	 */
	public BookAppDto getByBookAppId(Long bookAppId);

	/**
	 * 获取图书关联应用个数
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer getAppCount(Map<String, Object> paramMap);

	/**
	 * 删除应用关联图书
	 * 
	 * @param paramMap
	 */
	public void deleteByAppId(Map<String, Object> paramMap);

	/**
	 * 删除书籍和应用的关系
	 * 
	 * @param paramMap
	 */
	public void updateBookApp4Adviser(Map<String, Object> paramMap);

}
