package com.pcloud.book.cultivate.dao.impl;

import com.pcloud.book.cultivate.dao.CultivateRecordDao;
import com.pcloud.book.cultivate.entity.CultivateRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("cultivateRecordDao")
public class CultivateRecordDaoImpl extends BaseDaoImpl<CultivateRecord> implements CultivateRecordDao {
    @Override
    public Integer getEnergyConsumptionAfter(Long cultivateRecordId, Long wechatUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateRecordId",cultivateRecordId);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getEnergyConsumptionAfter"), map);
    }

    @Override
    public CultivateRecord getLastEnergyConsumptionRecord(Long wechatUserId, Long cultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getLastEnergyConsumptionRecord"), map);
    }

    @Override
    public Integer getUserGatherFishBallCount(Long wechatUserId, Long cultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getUserGatherFishBallCount"), map);
    }

    @Override
    public CultivateRecord getLastLighten(Long wechatUserId, Long cultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getLastLighten"), map);
    }

    @Override
    public CultivateRecord getLastEnergyConsumptionBefore(Long cultivateRecordId, Long wechatUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateRecordId",cultivateRecordId);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getLastEnergyConsumptionBefore"), map);
    }

}
