package com.pcloud.book.cultivate.enums;

public enum CultivateChangeTypeEnum {

    //1鱼丸获取2点亮3熄灭4升级5使用能量值6使用技能7鱼丸兑换星星
    /**
     * 鱼丸获取
     */
    GET_FISH_BALL(1, "鱼丸获取"),

    /**
     * 点亮
     */
    LIGHTEN(2, "点亮"),
    /**
     * 熄灭
     */
    QUENCH(3, "熄灭"),
    /**
     * 升级
     */
    UPGRADE(4, "升级"),
    /**
     * 使用能量值
     */
    USE_ENERGY(5, "使用能量值"),
    /**
     * 使用技能
     */
    USE_SKILL(6,"使用技能"),
    /**
     * 鱼丸兑换星星
     */
    FISH_BALL_CONVERT_STAR(7,"鱼丸兑换星星");


    public final Integer code;

    public final String name;

    CultivateChangeTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(Integer code) {
        if (code==null) {
            return null;
        }
        CultivateChangeTypeEnum[] all = values();
        int length = all.length;
        for (int i = 0; i < length; ++i) {
            CultivateChangeTypeEnum cultivateChangeTypeEnum = all[i];
            if (cultivateChangeTypeEnum.code.equals(code)) {
                return cultivateChangeTypeEnum.name;
            }
        }
        return null;
    }

}
