package com.pcloud.book.custom.mapper;


import com.pcloud.book.custom.entity.CustomPlanModuleSuggestion;
import com.pcloud.book.custom.vo.AddBookNameVO;
import com.pcloud.book.custom.vo.AddCustomPlan4UserVO;
import com.pcloud.book.custom.vo.ModuleSuggestionVO;
import com.pcloud.book.custom.vo.SuggestionListVO;
import com.pcloud.book.custom.vo.UserBookServiceVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface CustomPlanModuleSuggestionMapper {

    Integer getSuggestionCount(@Param("startTime") String startTime, @Param("endTime") String endTime,
                               @Param("wxIdList") List<String> wxIdList, @Param("planId") Integer planId);

    List<SuggestionListVO> listSuggestion4Plan(@Param("pageNum") int pageNum, @Param("numPerPage") int numPerPage,
                                               @Param("startTime") String startTime, @Param("endTime") String endTime,
                                               @Param("wxIdList") List<String> wxIdList, @Param("planId") Integer planId);

    List<ModuleSuggestionVO> getSuggestionInfo(@Param("batchId") Integer batchId, @Param("planId") Integer planId);

    Integer getMaxBatchId();

    void batchInsert(@Param("list") List<CustomPlanModuleSuggestion> list);

    Integer addCustomPlan4User(AddCustomPlan4UserVO addCustomPlan4UserVO);

    Integer getLatestPlanId(String wxId);

    List<Integer> getPlanIdListByUser(@Param("wxId") String wxId);

    Integer addBookNameAndServiceType(AddBookNameVO addBookNameVO);

    AddBookNameVO getUserBookAdnServiceType(@Param("wxId") String wxId, @Param("robotWxId") String robotWxId, @Param("type") Integer type);

    UserBookServiceVO getLastUserBookService(@Param("wxId") String wxId, @Param("robotWxId") String robotWxId);

    UserBookServiceVO getUserBookServiceById(@Param("userBookServiceId") Long userBookServiceId);
}