package com.pcloud.book.group.vo;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/30 15:13
 */
@ApiModel
public class ListGroupQrParam implements Serializable {

    @ApiModelProperty("当前页数")
    private Integer currentPage;

    @ApiModelProperty("每页条数")
    private Integer numPerPage;

    @ApiModelProperty("图书标识")
    private List<Long> bookIds;

    @ApiModelProperty("群名称或者书刊名称")
    private String name;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public List<Long> getBookIds() {
        return bookIds;
    }

    public void setBookIds(List<Long> bookIds) {
        this.bookIds = bookIds;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "ListGroupQrParam{" +
                "currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                ", bookIds=" + bookIds +
                ", name='" + name + '\'' +
                '}';
    }
}
