package com.pcloud.book.weixinclock.dao;

import com.pcloud.book.weixinclock.dto.GetByMemberAndUserDto;
import com.pcloud.book.weixinclock.dto.ListWeixinClockRankDto;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.entity.WeixinClockPraise;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Describe: 打卡点赞dao
 * @Author: zhangdongwei
 * @Date: Create on 17:19 2019/10/22 0022
 */
public interface WeixinClockPraiseDao extends BaseDao<WeixinClockPraise> {
    /**
     * 获取用户为成员点赞信息
     * @param dto
     * @return
     */
    WeixinClockPraise getByMemberAndUser(GetByMemberAndUserDto dto);

    /**
     * 获取去打卡成员收到的点赞
     * @param dto
     * @return
     */
    List<WeixinClockPraise> getMemberPraise(ListWeixinClockRankDto dto);

    /**
     * 获取打卡成员收到的点赞数
     * @param wechatGroupId
     * @param wxUserId
     * @return
     */
    Integer getPraiseNum(String wechatGroupId, String wxUserId);

    /**
     * 获取点赞列表
     * @param wechatGroupId
     * @param wxUserId
     * @return
     */
    List<WeixinClockPraise> listByWxUserId(String wechatGroupId, String wxUserId);

    /**
     * 旧数据处理：获取所有的打卡成员收到的点赞数
     * @return
     */
    List<RankDto> listAll();
}
