package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingWechatMsgDao;
import com.pcloud.book.advertising.entity.AdvertisingWechatMsg;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @描述：微信群消息
 * @作者：zhuyajie
 * @创建时间：15:24 2019/9/2
 * @版本：1.0
 */
@Component("advertisingWechatMsgDao")
public class AdvertisingWechatMsgDaoImpl extends BaseDaoImpl<AdvertisingWechatMsg> implements AdvertisingWechatMsgDao {

    @Override
    public List<AdvertisingWechatMsg> getByAdId(Long adId) {
        return getSessionTemplate().selectList(getStatement("getByAdId"), adId);
    }

    @Override
    public void deleteByAdId(Long adId) {
        getSessionTemplate().delete(getStatement("deleteByAdId"), adId);
    }
}
