package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.dto.CheckUserAuthDTO;
import com.pcloud.book.copyright.entity.BookAuthUser;
import com.pcloud.book.copyright.vo.BookAuthCodeUserVO;
import com.pcloud.book.copyright.vo.BookClickBuyRecordParam;
import com.pcloud.book.copyright.vo.ProvinceTop10VO;
import com.pcloud.book.copyright.vo.SixMonthCountVO;
import com.pcloud.book.copyright.vo.ThirtyDayCountVO;

import java.util.List;

/**
 * @author lily
 * @date 2018/12/4 15:54
 */
public interface BookAuthUserBiz {
    /**
     * 获取授权用户数量
     */
    BookAuthCodeUserVO getAuthUserCount(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     * 根据月份获取授权用户数量
     */
    BookAuthCodeUserVO getAuthUserCountByMonth(Long bookId, Long channelId, Long adviserId, String monthDate);

    /**
     * 最近30天趋势图
     */
    List<ThirtyDayCountVO> listThirtyDay(Long bookId, Long channelId, Long adviserId, String province, Integer authBookType);

    /**
     * 最近6个月趋势图
     */
    List<SixMonthCountVO> listSixMonth(Long bookId, Long channelId, Long adviserId, String province, Integer authBookType);

    /**
     * 新增用户授权记录
     */
    void insert(BookAuthUser bookAuthUser);

    /**
     * 校验用户是否已经授权
     */
    Boolean checkIsHaveAuth(Long bookId, Long channelId, Long adviserId, Long wechatUserId, Integer authBookType);

    /**
     * 校验用户针对指定的服务是否被授权
     */
    Boolean checkIsHaveAuthWithServer(String userInfo, Long serverId);

    /**
     * 获取授权信息总的统计数据
     */
    BookAuthCodeUserVO getAuthUserTotalCount(List<Long> adviserIds, List<Long> removeAdviserIds);

	 /**
     * 新增点击购买记录
     */
    void insertClickBuyRecord(BookClickBuyRecordParam bookClickBuyRecordParam, Long channelId, Long wechatUserId);

    /**
     * 省份排名前10
     */
    List<ProvinceTop10VO> listTop10ByBook(Long bookId, Long channelId, Long adviserId, Integer type);

    /**
     * 校验用户是否授权(进群)
     */
    Boolean checkUserIsHaveAuth(CheckUserAuthDTO checkUserAuthDTO);
}
