package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.DayCountDTO;
import com.pcloud.book.group.entity.BookGroupCipherUser;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/24 15:18
 **/
public interface BookGroupCipherUserDao extends BaseDao<BookGroupCipherUser> {

    Long getBookGroupIdByWxUserId(String wxUserId);

    /**
     * 社群码好友数量
     * @param bookGroupId
     * @return
     */
    public Integer getFriendsCountByBookGroup(Long bookGroupId);

    /**
     * 日加好友数量
     * @param bookGroupId
     * @param startTime
     * @param endTime
     * @return
     */
    List<DayCountDTO> getBookGroupFriendsCountByDay(Long bookGroupId, String startTime, String endTime);
    /**
     * 根据时间查社群码好友数量
     * @param bookGroupId
     * @return
     */
    public Integer getFriendsCountByBookGroupByTime(Long bookGroupId, String startTime, String endTime);
}
