package com.pcloud.book.group.dao;

import com.pcloud.book.advertising.dto.GroupTagDTO;
import com.pcloud.book.advertising.dto.WeixinClassifyInfoDTO;
import com.pcloud.book.group.dto.ChangeGroupNameDTO;
import com.pcloud.book.group.dto.GroupAndUserNumberDTO;
import com.pcloud.book.group.dto.GroupQrcodeDTO;
import com.pcloud.book.group.dto.GroupQrcodeFoAdDTO;
import com.pcloud.book.group.dto.GroupQrcodeInfo4Advertising;
import com.pcloud.book.group.dto.GroupQrcodeInfoDTO;
import com.pcloud.book.group.dto.GroupQrcodeServerDTO;
import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.vo.ClassifyQrcodeVO;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.ListGroupQrcodeResponseVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 16:38
 */
public interface GroupQrcodeDao extends BaseDao<GroupQrcode> {

    List<GroupQrcodeServerDTO> getWxGroupIdByServerId(List<Long> serverId);

    Integer updateGroupCount(String wxGroupId, Integer num);

    void updateGroupQrcode(Long groupQrcodeId, String qrcodeUrl, Long userId);

    List<ListGroupQrcodeResponseVO> listAllGroupQrcode(String groupName);
    /**
     * @Author:lili
     * @Desr:根据分类标识删除微信群
     * @Date:2019/4/18 11:56
     */
    void deleteByClassifyId(Long classifyId);

    /**
     * @Author:lili
     * @Desr:批量获取群数量与群总人数
     * @Date:2019/4/18 20:09
     */
    Map<Long, GroupAndUserNumberDTO> listGroupAndUserNumber(List<Long> classifyIds);

    /**
     * @Author:lili
     * @Desr: 修改群名称
     * @Date:2019/4/19 15:53
     */
    void modifyNameById(String wechatGroupName, Long id, Long updateUser);

    /**
     * @Author:lili
     * @Desr:更新二维码url
     * @Date:2019/3/11 20:47
     */
    void updateQrUrl(UpdateQrDTO updateQrDTO);

    /**
     * @Author:lili
     * @Desr:获取修改群信息
     * @Date:2019/4/2 16:52
     */
    List<ChangeGroupNameDTO> getWechatGroupInfo(List<Long> ids);

    /**
     * @Author:lili
     * @Desr:同步微信群标识
     * @Date:2019/4/3 11:14
     */
    void syncWeixinGroupId(Long weixinQrcodeId, String weixinGroupId);

    /**
     * @Author:lili
     * @Desr:更新用户数
     * @Date:2019/4/28 14:50
     */
    void updateUserNumber(String wechatGroupId, Integer memberCount);

    /**
     * @Author:lili
     * @Desr: 获取分类二维码基本信息
     * @Date:2019/4/28 15:31
     */
    GroupQrcodeDTO getGroupQrcodeInfo(String weixinGroupId);

    /**
     * @Author:lili
     * @Desr:更新群使用状态
     * @Date:2019/4/28 16:57
     */
    void updateUseState(Long id, Integer useState);

    /**
     * @Author:lili
     * @Desr:修改二维码状态
     * @Date:2019/4/28 17:20
     */
    Integer changeQrcodeState(Long id, Integer qrcode_state);

    Integer changeQrcodeStateForNotOver(Long id, Integer qrcode_state);

    /**
     * @Author:lili
     * @Desr:获取群二维码相关信息
     * @Date:2019/4/29 14:48
     */
    Map<Long,GroupQrcodeInfoDTO> listQrcodeInfoByIds(List<Long> groupQrcodeIds);

    /**
     * @Author:lili
     * @Desr:获取群二维码基本信息
     * @Date:2019/5/6 16:13
     */
    GroupQrcodeBaseInfoVO getBaseById(Long groupQrcodeId);

    /**
     * @Author:lili
     * @Desr:获取更新群名称的参数
     * @Date:2019/5/7 18:14
     */
    ChangeGroupNameDTO getUpdateGroupNameParam(Long id);

    /**
     * 根据社群书二维码id查询群id集合
     * @param bookGroupId
     * @return
     */
    List<String> getWeixinGroupIdsByBookGroupId(Long bookGroupId);

    /**
     * 根据群分类id查询群id集合
     * @param classifyId
     * @return
     */
    List<String> getWeixinGroupIdsByClassifyId(Long classifyId);

    /**
     * 根据群号查询
     * @param wechatGroupId
     * @return
     */
    GroupQrcode getGroupQrcodeByGroupId(String wechatGroupId);

    /**
    * @description 根据qrcodeId获取微信群信息
    * @author 戴兴
    * @date 2019/9/20 16:40
    */
    GroupQrcode getGroupQrcodeByqrcodeId(Long qrcodeId);

    /**
     * @Author: zhangdongwei
     * 根据群分类ids获取群总数
     * @param classifyIds
     * @return
     */
    Integer countByClassifyIds(List<Long> classifyIds);

    /**
     * 根据群分类id集合查询群id集合
     * @param classifyIds
     * @return
     */
    List<String> getWeixinGroupIdsByClassifyIdList(List<Long> classifyIds);

    /**
     * 根据群分类查询id集合
     * @param classifyId
     * @return
     */
    List<Long> getIdsByClassifyId(Long classifyId);

    /**
     * 修改群名称
     * @param id
     * @param groupName
     */
    void updateGroupName(Long id, String groupName);

    /**
     * 获取群人数大于或等于人数的群
     * @param userCount
     */
    List<GroupQrcode> getListByUserCount(Integer userCount);

    /**
     * 群信息及广告位信息
     * @param wxGroupIds
     * @return
     */
    List<GroupQrcodeInfo4Advertising>getGroupInfo4AdvertisingByWxGroupIds(List<String> wxGroupIds);

    /**
     * 按条件查微信群
     * @param paramMap
     * @return
     */
    List<Long> listQrcodeIdsByLabelQuery(Map<String, Object> paramMap);

    /**
     * 根据id集合查询微信群相关信息
     */
    List<WeixinClassifyInfoDTO> getGroupInfoByQrcodeId(List<Long> ids);

    /**
     * 过滤删除的群二维码id
     * @param wxGroupIdList
     * @return
     */
    List<Long> filterDeleteQrcodeId(List<String> wxGroupIdList);

    /**
     * 根据分类id集合查询
     */
    List<GroupQrcodeFoAdDTO> GroupQrcodeFoAdDTOSByClassifyIds(List<Long> classifyIds);

    /**
     * 修改猜谜语开启状态
     * @param qrcodeId
     * @param status
     */
    void updateRiddleOpenStatus(Long qrcodeId, Boolean status);

    /**
     * 根据分类id获取分类下的群---不分页
     */

    /**
     * 书下所有群
     * @param bookId
     * @return
     */
    public List<Long> getIdsByBookId(Long bookId);

    /**
     * 群所属书id
     * @param qrcodeId
     * @return
     */
    public Long getBookIdByGroupQrcodeId(Long qrcodeId);

    /**
     * 查书下群数量群人数
     * @param bookId
     * @return
     */
    public Map<String, Object> getGroupCountUserCountByBookId(Long bookId);

    /**
     * 查询微信群品牌方标记列表
     * @param map
     * @return
     */
    public List<GroupTagDTO> listPageGroup4Brand(Map<String, Object> map);


    List<ClassifyQrcodeVO> getQrcodeByClassify(Long classifyId);

    List<ClassifyQrcodeVO> getQrcodeByClassifyId(Long classifyId);

    List<GroupQrcode> getListByBookGroupIds(List<Long> bookGroupIds);

    Map<Long, GroupQrcodeInfo4Advertising> getWechatGroupInfoMap(List<Long> qrcodeIds);

    /**
     * 根据社群书id查群ids
     * @param bookGroupId
     * @return
     */
    List<Long> getIdsByBookGroupId(Long bookGroupId);
}
