package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.entity.BookGroupClassify;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.vo.FriendsVO;
import com.pcloud.book.group.vo.GroupIncomeStaticParamVO;
import com.pcloud.book.group.vo.GroupScanTrendParamVO;
import com.pcloud.book.group.vo.GroupScanTrendVO;
import com.pcloud.book.group.vo.ListBookGroup4ChannelParamVO;
import com.pcloud.book.group.vo.ResourcesStatisticVO;
import com.pcloud.book.group.vo.UpdateRankTypeVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.book.group.vo.BookGroupAnalysisParam;
import com.pcloud.book.group.vo.BookGroupAnalysisVO;
import com.pcloud.book.group.vo.GroupIncomeStaticParamVO;
import com.pcloud.book.group.vo.GroupScanTrendParamVO;
import com.pcloud.book.group.vo.GroupScanTrendVO;
import com.pcloud.book.group.vo.ListBookGroup4ChannelParamVO;
import com.pcloud.book.group.vo.ResourcesStatisticVO;
import com.pcloud.book.group.vo.UpdateRankTypeVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;

import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;


/**
 * Description 社群书群二维码接口
 * Created by PENG on 2019/4/17.
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookGroupFacadeCloud", path = "bookGroup")
@Api(description = "社群书群二维码接口")
public interface BookGroupFacade {

    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "群二维码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfo", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfo(@RequestHeader("token") String token, @RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "群二维码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfo4Wechat", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfo4Wechat(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书刊ID", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "运营ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfoByBookId", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfoByBookId(@RequestHeader("token") String token, @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "addType", required = false) Integer addType, @RequestParam(value = "sceneId", required = false) Long sceneId,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "是否有社群码", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书刊ID", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "运营ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "isHaveQrcode", method = RequestMethod.GET)
    ResponseDto<Boolean> isHaveQrcode(@RequestHeader("token") String token, @RequestParam(value = "bookId", required = false) Long bookId,
                                      @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;



    @ApiOperation(value = "更新群二维码信息", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroup", value = "群二维码实体", dataType = "BookGroup", paramType = "body")
    })
    @RequestMapping(value = "updateBookGroup", method = RequestMethod.POST)
    ResponseDto<?> updateBookGroup(@RequestHeader("token") String token, @RequestBody BookGroup bookGroup)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "根据社群码ID获取书名", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "社群码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookNameByBookGroupId", method = RequestMethod.GET)
    ResponseDto<?> getBookNameByBookGroupId(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书列表(编辑)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isMainEditor", value = "只看我是主编辑", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "只看基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始时间", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束时间", dataType = "string", paramType = "query"),
    })
    @RequestMapping(value = "listBookGroup4Adviser", method = RequestMethod.GET)
    ResponseDto<PageBean> listBookGroup4Adviser(@RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "bookName", required = false) String bookName,
            @RequestParam(value = "isbn", required = false) String isbn,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "typeCode", required = false) String typeCode,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage,
            @RequestParam(value = "isMainEditor", required = false) Integer isMainEditor,
            @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
            @RequestParam(value = "bookId", required = false) Integer bookId,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType,
            @RequestParam(value = "startDate", required = false) String startDate,
            @RequestParam(value = "endDate", required = false) String endDate)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取社群书列表(运营)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "listBookGroup4ChannelParamVO", value = "ListBookGroup4ChannelParamVO", dataType = "ListBookGroup4ChannelParamVO", paramType = "body")
    })
    @RequestMapping(value = "listBookGroup4Channel", method = RequestMethod.POST)
    ResponseDto<PageBean> listBookGroup4Channel(@RequestHeader("token") String token,
                                                @RequestBody ListBookGroup4ChannelParamVO listBookGroup4ChannelParamVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取用户购买或者参与过的社群书信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "Integer", paramType = "query")
    })
    @RequestMapping(value = "getUserBrowseGroup4KnowLedgeMall", method = RequestMethod.GET)
    ResponseDto<?> getUserBrowseGroup4KnowLedgeMall(@CookieValue("userInfo")String userInfo,
                                                           @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                                           @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取社群书列表(编辑)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "name", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "Integer", paramType = "query")
    })
    @RequestMapping(value = "listSimpleBookGroup4Adviser", method = RequestMethod.GET)
    ResponseDto<?> listSimpleBookGroup4Adviser(@RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取未创建社群码的书刊列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "name", value = "搜索字段", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "listBook4CreateBookGroup", method = RequestMethod.GET)
    ResponseDto<?> listBook4CreateBookGroup(@RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改排序规则", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateRankTypeVO", value = "更新排序", dataType = "UpdateRankTypeVO", paramType = "body")
    })
    @PostMapping("updateRankType")
    ResponseDto<?> updateRankType(@RequestHeader("token") String token, @RequestBody UpdateRankTypeVO updateRankTypeVO)
            throws BizException, JsonParseException, PermissionException;

    @GetMapping("getRankType")
    @ApiOperation(value = "获取排序规则", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "社群码标识", dataType = "Long", paramType = "query")
    })
    ResponseDto<Integer> getRankType(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookQrcodeId) throws BizException;

    @ApiOperation(value = "编辑获取社群码总数量", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @RequestMapping(value = "getTotalBookGroupCount", method = RequestMethod.GET)
    ResponseDto<?> getTotalBookGroupCount(@RequestHeader("token") String token) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书分类列表(编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupClassify", value = "群分类实体", dataType = "BookGroupClassify", paramType = "body")
    })
    @RequestMapping(value = "listSimpleBookGroupClassify4Adviser", method = RequestMethod.POST)
    ResponseDto<?> listSimpleBookGroupClassify4Adviser(@RequestHeader("token") String token,
                                               @RequestBody BookGroupClassify bookGroupClassify) throws BizException, PermissionException;

    @ApiOperation(value = "是否是特殊的出版社", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @RequestMapping(value = "isSpecialAgent", method = RequestMethod.GET)
    ResponseDto<Boolean> isSpecialAgent(@RequestHeader("token") String token) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取应用作品统计")
    @GetMapping("getAppStatistics")
    ResponseDto<?> getAppStatistics(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam("bookGroupId") Long bookGroupId,
            @RequestParam(value = "qrcodeId",required = false) Long qrcodeId
    ) throws BizException, PermissionException, JsonParseException;


    @ApiOperation(value = "导出社群码(编辑)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isMainEditor", value = "只看我是主编辑", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "只看基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始时间", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束时间", dataType = "string", paramType = "query"),
    })
    @RequestMapping(value = "exportGroupQrcode4Adviser", method = RequestMethod.GET)
    ResponseDto<?> exportGroupQrcode4Adviser(@RequestHeader("token") String token,
                                                @RequestParam(value = "name", required = false) String name,
                                                @RequestParam(value = "bookName", required = false) String bookName,
                                                @RequestParam(value = "isbn", required = false) String isbn,
                                                @RequestParam(value = "channelId", required = false) Long channelId,
                                                @RequestParam(value = "typeCode", required = false) String typeCode,
                                                @RequestParam(value = "isMainEditor", required = false) Integer isMainEditor,
                                                @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                                @RequestParam(value = "bookId", required = false) Integer bookId,
                                                @RequestParam(value = "startDate", required = false) String startDate,
                                                @RequestParam(value = "endDate", required = false) String endDate)
            throws BizException, PermissionException;

    @ApiOperation("根据bookId获取社群书分类等统计")
    @GetMapping("getBookGroupStatistics")
    ResponseDto<?> getBookGroupStatistics(
            @RequestHeader("token") String token,
            @RequestParam("bookId") Long bookId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("根据bookId获取社群书分类和关键词等统计信息")
    @GetMapping("getBookGroupKeywordStatistics")
    ResponseDto<?> getBookGroupKeywordStatistics(
            @RequestHeader("token") String token,
            @RequestParam("bookId") Long bookId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("更新是否显示书名")
    @GetMapping("updateIsShowBookName")
    ResponseDto<?> updateIsShowBookName(
            @RequestHeader("token") String token,
            @RequestParam("isShowBookName") Boolean isShowBookName
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取是否显示书名")
    @GetMapping("getIsShowBookName")
    ResponseDto<?> getIsShowBookName(
            @RequestHeader("token") String token
    ) throws BizException, PermissionException, JsonParseException;


    @ApiOperation("删除社群码")
    @GetMapping("deleteBookGroup")
    ResponseDto<?> deleteBookGroup(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") Long bookGroupId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("根据社群书id获取个人二维码")
    @GetMapping("getOwnAltQrcodeInfoDTOByBookGroupId")
    ResponseDto<?> getOwnAltQrcodeInfoDTOByBookGroupId(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") Long bookGroupId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("根据分类id获取个人二维码")
    @GetMapping("getOwnAltQrcodeInfoDTOByClassifyId")
    ResponseDto<?> getOwnAltQrcodeInfoDTOByClassifyId(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("classifyId") Long classifyId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("根据分类id获取个人二维码")
    @GetMapping("getOwnAltQrcodeInfoDTOByQrcodeId")
    ResponseDto<?> getOwnAltQrcodeInfoDTOByQrcodeId(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("qrcodeId") Long qrcodeId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取所有的大类")
    @GetMapping("getAllLargeTemplet")
    ResponseDto<?> getAllLargeTemplet(
            @RequestHeader("token") String token
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取社群书数据")
    @RequestMapping(value = "getBookGroupStatisByBookGroupId",method = RequestMethod.GET)
    ResponseDto<?> getBookGroupStatisByBookGroupId(@RequestParam("bookGroupId")Long bookGroupId) throws BizException;

    @ApiOperation(value = "收益统计--pc", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "groupIncomeStaticParamVO", value = "GroupIncomeStaticParamVO", required = true, dataType = "GroupIncomeStaticParamVO", paramType = "body")
    })
    @RequestMapping(value ="getGroupIncomeStatic",method = RequestMethod.POST)
    public ResponseDto<PageBeanNew<ResourcesStatisticVO>> getGroupIncomeStatic(@RequestHeader("token") String token,
                                                                               @RequestBody GroupIncomeStaticParamVO groupIncomeStaticParamVO) throws BizException, PermissionException;

    @ApiOperation(value = "社群码浏览趋势图--pc", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "groupScanTrendParamVO", value = "GroupScanTrendParamVO", required = true, dataType = "GroupScanTrendParamVO", paramType = "body")
    })
    @RequestMapping(value ="getGroupScanTrend",method = RequestMethod.POST)
    public ResponseDto<List<GroupScanTrendVO>> getGroupScanTrend(@RequestHeader("token") String token,
                                                                 @RequestBody GroupScanTrendParamVO groupScanTrendParamVO) throws BizException, PermissionException;

    @ApiOperation(value = "社群码分类统计--pc", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "currentPage", required = true, dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "numPerPage", required = true, dataType = "Integer", paramType = "query")
    })
    @RequestMapping(value ="getClassifyStatistic",method = RequestMethod.GET)
    public ResponseDto<?> getClassifyStatistic(@RequestHeader("token") String token,
                                               @RequestParam(value = "bookGroupId",required = true) Long bookGroupId,
                                               @RequestParam(value = "currentPage",required = true) Integer currentPage,
                                               @RequestParam(value = "numPerPage",required = true) Integer numPerPage) throws BizException, PermissionException;

    @ApiOperation(value = "社群码分类下的微信群统计--pc", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "classifyId", value = "classifyId", required = true, dataType = "Long", paramType = "query")
    })
    @RequestMapping(value ="getQrcodeStatistic",method = RequestMethod.GET)
    public ResponseDto<?> getQrcodeStatistic(@RequestHeader("token") String token,
                                                                    @RequestParam(value = "bookGroupId",required = true) Long bookGroupId,
                                                                    @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException;


    @ApiOperation(value = "资源数据统计--pc", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "classifyId",value = "classifyId",required = false,dataType = "Long",paramType = "query"),
            @ApiImplicitParam(name = "qrcodeId",value = "qrcodeId",required = false,dataType = "Long",paramType = "query"),
            @ApiImplicitParam(name = "type",value = "type",required = true,dataType = "String",paramType = "query")
    })
    @RequestMapping(value ="getTotalRescourceData",method = RequestMethod.GET)
    public ResponseDto<?> getTotalRescourceData(@RequestHeader("token") String token, @RequestParam(value = "bookGroupId",required = true) Long bookGroupId,
                                                @RequestParam(value = "classifyId",required = false) Long classifyId, @RequestParam(value = "qrcodeId",required = false) Long qrcodeId,
                                                @RequestParam("type") String type) throws BizException, PermissionException;

    @ApiOperation(value = "社群码资源收益数据导出--pc", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", required = true, dataType = "Long", paramType = "query")
    })
    @RequestMapping(value ="exportRescourceIncomeData",method = RequestMethod.GET)
    public ResponseDto<?> exportRescourceIncomeData(@RequestHeader("token") String token,
                                                    @RequestParam(value = "bookGroupId",required = true) Long bookGroupId) throws BizException, PermissionException;

    @ApiOperation(value = "用户发言数据列表--1v1入群", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "currentPage", required = true, dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "numPerPage", required = true, dataType = "Integer", paramType = "query")
    })
    @GetMapping("listPageFriendsStatistic")
    public ResponseDto<PageBeanNew<FriendsVO>> listPageFriendsStatistic(
            @RequestHeader("token") String token, @RequestParam(value = "bookGroupId", required = true) Long bookGroupId,
            @RequestParam(value = "currentPage", required = true) Integer currentPage,
            @RequestParam(value = "numPerPage", required = true) Integer numPerPage) throws BizException, PermissionException;

    @ApiOperation("批量新增资源配置")
    @PostMapping("batchAddBookGroupServe")
    ResponseDto<?> batchAddBookGroupServe(
            @RequestHeader("token") String token,
            @RequestBody List<BookGroupServe> bookGroupServes
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("批量更新资源配置")
    @PostMapping("batchUpdateBookGroupServe")
    ResponseDto<?> batchUpdateBookGroupServe(
            @RequestHeader("token") String token,
            @RequestBody List<BookGroupServe> bookGroupServes
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("删除资源配置")
    @GetMapping("deleteBookGroupServe")
    ResponseDto<?> deleteBookGroupServe(
            @RequestHeader("token") String token,
            @RequestParam("id") Long id
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取资源配置集合")
    @GetMapping("getBookGroupServeList")
    ResponseDto<?> getBookGroupServeList(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") Long bookGroupId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取社群码暗号")
    @GetMapping("getBookGroupCipher")
    ResponseDto<?> getBookGroupCipher(
            @RequestHeader("token") String token
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "平台端-社群书分析", httpMethod = "POST")
    @PostMapping("listPageBookGroupAnalysis")
    public ResponseDto<PageBeanNew<BookGroupAnalysisVO>> listPageBookGroupAnalysis(
            @RequestHeader("token") String token, @RequestBody @ApiParam BookGroupAnalysisParam bookGroupAnalysisParam) throws PermissionException;

    @ApiOperation(value = "平台端-社群书分析-异步导出", httpMethod = "POST")
    @PostMapping("exportBookGroupAnalysis")
    public ResponseDto<?>exportBookGroupAnalysis(
            @RequestHeader("token") String token, @RequestBody @ApiParam BookGroupAnalysisParam bookGroupAnalysisParam) throws PermissionException;

}
