package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletRecordBiz;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.book.applet.vo.AppletRecordQueryVO;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * (AppletRecord)表控制层
 *
 * @author makejava
 * @since 2020-08-27 15:41:19
 */
@RestController("appletRecordFacade")
@RequestMapping("appletRecord")
public class AppletRecordFacade {

    @Autowired
    private AppletRecordBiz appletRecordBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo, @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert( @CookieValue("userInfo") String userInfo, @RequestBody AppletRecord appletRecord)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long accountSettingId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        appletRecord.setWechatUserId(wechatUserId);
        appletRecord.setAccountSettingId(accountSettingId);
        return new ResponseDto<>(appletRecordBiz.insert(appletRecord));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update( @CookieValue("userInfo") String userInfo, @RequestBody AppletRecord appletRecord) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        appletRecordBiz.update(appletRecord);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById( @CookieValue("userInfo") String userInfo,@RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        appletRecordBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @RequestMapping(value = "listAppletRecord", method = RequestMethod.POST)
    public ResponseDto<PageBeanNew<AppletRecordDTO>> listAppletRecord(@CookieValue("userInfo") String userInfo,
                                                                     @RequestBody AppletRecordQueryVO appletRecordQueryVO) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        PageBeanNew<AppletRecordDTO> recordDTOPageBeanNew = appletRecordBiz.listAppletRecord(wechatUserId, appletRecordQueryVO.getDate(),
                appletRecordQueryVO.getRecordTypes(), appletRecordQueryVO.getQueryName(), appletRecordQueryVO.getCurrentPage(), appletRecordQueryVO.getNumPerPage());
        return new ResponseDto<>(recordDTOPageBeanNew);
    }

    @ApiOperation("获取没有埋点记录的日期列表（过去30天）")
    @RequestMapping(value = "listUnreachableDate",method = RequestMethod.GET)
    public ResponseDto<List<String>> listUnreachableDate(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordBiz.listUnreachableDate(wechatUserId));
    }

}