package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageDao;
import com.pcloud.book.personalstage.dto.PersonalStageDTO;
import com.pcloud.book.personalstage.entity.PersonalStage;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("personalStage")
public class PersonalStageDaoImpl extends BaseDaoImpl<PersonalStage> implements PersonalStageDao {
    @Override
    public void updateSeqNum(Long id, Integer seqNum) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("seqNum",seqNum);
        super.getSqlSession().update(getStatement("updateSeqNum"), map);
    }

    @Override
    public Integer getMaxSeqNum() {
        return  super.getSqlSession().selectOne(getStatement("getMaxSeqNum"));
    }

    @Override
    public Integer getCountByRobotClassifyId(Long robotClassifyId) {
        return super.getSqlSession().selectOne(getStatement("getCountByRobotClassifyId"), robotClassifyId);
    }

    @Override
    public PersonalStage getFirstStage(Long robotClassifyId) {
        return super.getSqlSession().selectOne(getStatement("getFirstStage"), robotClassifyId);
    }

    @Override
    public List<PersonalStageDTO> getPersonalStageList(Long robotClassifyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("robotClassifyId", robotClassifyId);
        return super.getSqlSession().selectList(getStatement("getPersonalStageList"), paramMap);
    }

    @Override
    public List<Long> getPaperIdListByRobotClassify(Long robotClassifyId) {
        return getSessionTemplate().selectList(getStatement("getPaperIdListByRobotClassify"), robotClassifyId);
    }
}
