package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AnswerSubscribeDao;
import com.pcloud.book.applet.entity.AnswerSubscribe;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AnswerSubscribeDaoImpl
 * @Author zhuyajie
 * @Description 答案订阅
 * @Date 2020/9/16 16:09
 * @Version 1.0
 **/
@Component
public class AnswerSubscribeDaoImpl extends BaseDaoImpl<AnswerSubscribe> implements AnswerSubscribeDao {

    @Override
    public void updateSendState(AnswerSubscribe answerSubscribe) {
        getSessionTemplate().update(getStatement("updateSendState"), answerSubscribe);
    }

    @Override
    public List<AnswerSubscribe> getRecordByUserBook(AnswerSubscribe answerSubscribe) {
        return getSessionTemplate().selectList(getStatement("getRecordByUserBook"), answerSubscribe);
    }

    @Override
    public List<AnswerSubscribe> getBySendStateAndBook(AnswerSubscribe answerSubscribe) {
        return getSessionTemplate().selectList(getStatement("getBySendStateAndBook"), answerSubscribe);
    }

    @Override
    public List<AnswerSubscribe> getBookBySendState(Integer sendState) {
        return getSessionTemplate().selectList(getStatement("getBookBySendState"), sendState);
    }
}
