package com.pcloud.book.rightsSetting.entity;

import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/19 17:41
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RightsNowItem extends BaseEntity {

    @ApiModelProperty("权益id")
    private Long rightsSettingId;
    @ApiModelProperty("应用/资讯/作品id")
    private Long serveId;
    @ApiModelProperty("应用/资讯/作品类型")
    private String serveType;
    @ApiModelProperty("链接url")
    private String linkUrl;
    @ApiModelProperty("类型（0咨询，1线上网课，2学习工具，3抽奖，4专享礼包券，6配套资料）")
    private Integer type;
    @ApiModelProperty("专享礼包券id")
    private Long giftCouponPackageId;
    @ApiModelProperty("应用/资讯/作品图片")
    private String servePic;
    @ApiModelProperty("应用/资讯/作品名称")
    private String serveName;
    @ApiModelProperty("应用/资讯/作品类型名称")
    private String serveTypeName;
    @ApiModelProperty("应用/资讯/作品类型编码")
    private String serveTypeCode;
    @ApiModelProperty("结果链接")
    private String resultUrl;
    @ApiModelProperty("专享礼包券名称")
    private String giftCouponTitle;
    @ApiModelProperty("专享礼包券有效期开始时间")
    private String giftCouponValidDateBegin;
    @ApiModelProperty("专享礼包券有效期结束时间")
    private String giftCouponValidDateEnd;
    @ApiModelProperty("专享礼包券面额")
    private Integer giftCouponDenomination;
    @ApiModelProperty("专享礼包券封面图")
    private String giftCouponCoverPic;
    @ApiModelProperty("专享礼包券领取状态")
    private Boolean userGiftReceive;
    @ApiModelProperty("权益配套资料分组id")
    private Long rightsItemGroupId;
    @ApiModelProperty("券类型（2-书币券，1-课程券）")
    private Integer couponType;
    @ApiModelProperty("使用说明")
    private String instructions;
    @ApiModelProperty("跳转类型")
    private Integer jumpType;
    @ApiModelProperty("跳转链接")
    private String jumpUrl;
    @ApiModelProperty("课程券使用方式（1-链接兑取，2-复制码）")
    private Integer useType;
    @ApiModelProperty("兑换地址")
    private String exchangeAddress;
    @ApiModelProperty("社群名称")
    private String groupName;
    @ApiModelProperty("社群简介")
    private String groupDesc;
    @ApiModelProperty("社群二维码")
    private String groupQrCode;
    @ApiModelProperty("社群信息")
    private GroupActivity4AppletDTO groupActivity4AppletDTO;
    @ApiModelProperty("资讯名称")
    private String newsName;
    @ApiModelProperty("来源")
    private String newsSource;
    @ApiModelProperty("来源")
    private String source;
    @ApiModelProperty("即享权益")
    private Long rightsSettingTitleId;
    @ApiModelProperty("关联社群ID")
    private Long relatedBookGroupId;
    @ApiModelProperty("群分类ID")
    private Long classifyId;
    @ApiModelProperty("社群书ID")
    private Long bookGroupId;
    @ApiModelProperty("群分类价格")
    private BigDecimal price;
    @ApiModelProperty("群类型 2:编辑端群")
    private String groupType;
    @ApiModelProperty("文章版式（1多图文2单图文3纯图片4纯文本)")
    private Integer newsType;
    @ApiModelProperty("预览图片1")
    private String pic1;
    @ApiModelProperty("预览图片2")
    private String pic2;
    @ApiModelProperty("预览图片3")
    private String pic3;
    @ApiModelProperty("内容摘要")
    private String digest;
    @ApiModelProperty("社群是否展示头图")
    private Integer isShow;
    @ApiModelProperty("社群头图地址")
    private String showUrl;
    @ApiModelProperty("是否收藏")
    private Integer isCollect;
    @ApiModelProperty("商品应用中有第三方链接")
    private Boolean hasThirdLink;
    @ApiModelProperty("跳转外链编号")
    private String urlNumber;

    @ApiModelProperty("划线价")
    private String crossedPrice;

    @ApiModelProperty("评估价")
    private String appraisalPrice;

    @ApiModelProperty("资讯浏览量")
    private Integer browseCount;

    @ApiModelProperty("应用/资讯/作品图片-大图")
    private String transverseImg;
}
