package com.pcloud.book.rightsSetting.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import com.pcloud.common.page.PageBeanNew;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class RightsSettingTitle extends BaseEntity {
    private Long id;

    private Long rightsSettingId;

    private String rightsSettingTitle;

    private String rightsSettingDesc;

    private Boolean openState;

    private Integer rightsSettingNowType;

    @JsonFormat(
        pattern = "yyyy-MM-dd HH:mm:ss",
        timezone = "GMT+8"
    )
    private Date createTime;

    @JsonFormat(
        pattern = "yyyy-MM-dd HH:mm:ss",
        timezone = "GMT+8"
    )
    private Date updateTime;

    private String serveType;

    /**
     * 分页
     */
    private PageBeanNew<RightsNowItem> rightsSettingItemList4Page;

    /**
     * 列表
     */
    private List<RightsNowItem> rightsSettingItemList;
    /**
     * 轻松阅读
     */
    private Boolean easyRead;
    /**
     * 高效阅读
     */
    private Boolean efficientRead;
    /**
     * 深度阅读
     */
    private Boolean deepRead;

    /**
     * 拼群开关 0 不拼 1 拼
     */
    private Integer collageState;

    private Integer seqNum;

    @ApiModelProperty("客户端展示类型0默认")
    private Integer displayType;
}