package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.common.page.PageBeanNew;

import java.util.Map;

/**
 * 小程序用户书架
 */
public interface AppletUserBookcaseBiz {

    /**
     * 添加图书到书架
     * @param appletUserBookcase
     */
    void addUserBook(AppletUserBookcase appletUserBookcase);

    /**
     * 查用户书架列表
     * @param wechatUserId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletUserBookcaseDTO> listByWechatUserId(Long wechatUserId, Integer currentPage, Integer numPerPage);

    /**
     * 新增用户资源点击记录
     * @param appletUserClickRecord
     */
    void addUserClickRecord(AppletUserClickRecord appletUserClickRecord);

    /**
     * 用户图书资源点击统计
     * @param wechatUserId
     * @param bookId
     * @return
     */
    Map<String,Object> getUserClickStatistic(Long wechatUserId, Long bookId, Long channelId, Long adviserId);
}
