package com.pcloud.book.applet.dto;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 学舍群管理(AppletGroupManage)实体类
 *
 * @author zyq
 * @since 2020-04-01 14:05:37
 */
@Data
public class AppletGroupManageDTO extends BaseEntity {
    
    private Long id;
    
    @ApiModelProperty("共读活动id")
    private Long groupActivityId;
    
    @ApiModelProperty("上架")
    private Integer enable;
    
    @ApiModelProperty("推荐到首页")
    private Integer recommend;

    @ApiModelProperty("共度名称")
    private String name;

    @ApiModelProperty("描述")
    private String desc;

    @ApiModelProperty("描述")
    private String cutDesc;

    @ApiModelProperty("群图片，加群方式为图片时有效")
    private String groupPic;

    @ApiModelProperty("社群码id")
    private Long bookGroupQrcodeId;

    @ApiModelProperty("社群码名称")
    private String groupName;

    @ApiModelProperty("专业标签id")
    private Long proLabelId;

    @ApiModelProperty("专业标签")
    private String proLabelName;

    @ApiModelProperty("深度标签id")
    private Long depLabelId;

    @ApiModelProperty("深度标签")
    private String depLabelName;

    @ApiModelProperty("目的标签id")
    private Long purLabelId;

    @ApiModelProperty("目的标签")
    private String purLabelName;

    @ApiModelProperty("群人数")
    private Integer userNumber;

    @ApiModelProperty("序号")
    private Integer seqNum;

    @ApiModelProperty("头像")
    private String qrcodeHeadUrl;

    @ApiModelProperty("群分类id")
    private Long classifyId;

    @ApiModelProperty("群id")
    private Long bookGroupId;

    @ApiModelProperty("头像列表")
    private List<String> headUrlList;

}