package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel("小程序用户书架栏目")
public class AppletUserBookcaseDTO extends BaseDto {

    @ApiModelProperty("图书id")
    private Long bookId;

    @ApiModelProperty("运营id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("封面")
    private String coverImg;

    @ApiModelProperty("出版名称")
    private String agentName;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date createTime;

    @ApiModelProperty("作者")
    private String author;
    @ApiModelProperty("出版社")
    private String publish;
    @ApiModelProperty("一级分类id")
    private Long templetId;

    @ApiModelProperty("一级分类名称")
    private String templetName;

    @ApiModelProperty("二级分类id")
    private Long secondTempletId;

    @ApiModelProperty("二级分类名")
    private String secondTempletName;
}
