package com.pcloud.book.rightsSetting.facade;

import com.pcloud.book.rightsSetting.biz.RightsSettingBiz;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping("rightsSetting")
@RestController("rightsSettingFacede")
public class RightsSettingFacede {

    @Autowired
    private RightsSettingBiz rightsSettingBiz;

    @PostMapping("addRightsSetting")
    public ResponseDto<Long> addRightsSetting(@RequestHeader("token") String token, @RequestBody RightsSetting rightsSetting) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<Long>(rightsSettingBiz.addRightsSetting(rightsSetting));
    }

    @GetMapping("deleteRightsSetting")
    public ResponseDto<?> deleteRightsSetting(@RequestHeader("token") String token, @RequestParam("id") Long id) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        rightsSettingBiz.deleteRightsSetting(id);
        return new ResponseDto<>();
    }

    @PostMapping("updateRightsSetting")
    public ResponseDto<?> updateRightsSetting(@RequestHeader("token") String token, @RequestBody RightsSetting rightsSetting) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        rightsSettingBiz.updateRightsSetting(rightsSetting);
        return new ResponseDto<>();
    }

    @GetMapping("getRightsSetting")
    public ResponseDto<RightsSetting> getRightsSetting(@RequestHeader("token") String token, @RequestParam("id") Long id) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<RightsSetting>(rightsSettingBiz.getRightsSetting(id));
    }

    @GetMapping("listRightsSettingPage")
    public ResponseDto<PageBeanNew<RightsSettingDto>> listRightsSettingPage(@RequestHeader("token") String token,
                                                                        @RequestParam("currentPage") Integer currentPage,
                                                                        @RequestParam("numPerPage") Integer numPerPage,
                                                                        @RequestParam(value = "firstClassify", required = false) Long firstClassify,
                                                                        @RequestParam(value = "secondClassify", required = false) Long secondClassify,
                                                                        @RequestParam(value = "gradeLabelId", required = false) Long gradeLabelId,
                                                                        @RequestParam(value = "subjectLabelId", required = false) Long subjectLabelId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        RightsSetting rightsSetting = new RightsSetting();
        rightsSetting.setFirstClassify(firstClassify);
        rightsSetting.setSecondClassify(secondClassify);
        rightsSetting.setGradeLabelId(gradeLabelId);
        rightsSetting.setSubjectLabelId(subjectLabelId);
        return new ResponseDto<PageBeanNew<RightsSettingDto>>(rightsSettingBiz.listRightsSettingPage(currentPage, numPerPage, rightsSetting));
    }

    @ApiOperation("获取读者数量-每天自增")
    @GetMapping("getUserCount")
    public ResponseDto<Integer> getUserCount(){
        return new ResponseDto<>(rightsSettingBiz.getUserCount());
    }
}