package com.pcloud.book.applet.biz;

import com.pcloud.appcenter.assist.dto.AssistTempletDTO;
import com.pcloud.book.applet.dto.AppletBookClassifyDTO;
import com.pcloud.book.applet.dto.AppletBookClassifyRelationDTO;
import com.pcloud.book.applet.dto.AppletUserLabelDTO;
import com.pcloud.book.applet.entity.AppletBookClassify;
import com.pcloud.book.applet.entity.AppletUserLabelRelation;

import java.util.List;
import java.util.Map;

/**
 * 小程序书刊分类
 * @author：zhuyajie
 * @date：2020/5/15 16:30
 *  * @param null
 */
public interface AppletBookClassifyBiz {

    /**
     * 书刊分类查询
     * @author：zhuyajie
     * @date：2020/5/15 16:31
     *  * @param null
     */
    List<AppletBookClassifyDTO> getAppletBookClassifyList(Boolean showState);

    /**
     * 根据id查询
     * @author：zhuyajie
     * @date：2020/5/15 16:32
     *  * @param null
     */
    AppletBookClassifyDTO getById(Long id);
    /**
     * 修改书刊分类
     * @author：zhuyajie
     * @date：2020/5/15 16:33
     *  * @param null
     */
    void update(AppletBookClassify appletBookClassify);

    /**
     * 平台端新增客户端标签
     * @param appletUserLabelDTO
     */
    void addUserLabel(AppletUserLabelDTO appletUserLabelDTO);

    /**
     * 关联书刊一级分类
     * @author：zhuyajie
     * @date：2020/5/18 13:59
     *  * @param null
     */
    void addBookTempletRelation(List<Long> templetIdList, Long bookClassifyId);
    /**
     * 根据小程序书刊分类id查书刊一级分类
     * @author：zhuyajie
     * @date：2020/5/18
     *  * @param null
     */
    List<AppletBookClassifyRelationDTO> getRelationBookTempletByBookClassifyId(Long bookClassifyId);

    /**
     * 更新客户端标签
     * @param appletUserLabelDTO
     */
    void updateUserLabel(AppletUserLabelDTO appletUserLabelDTO);

    /**
     * 删除客户端标签
     * @param id
     */
    void deleteUserLabel(Long id);

    /**
     * 客户端标签列表
     * @param appletBookClassifyId
     * @return
     */
    List<AppletUserLabelDTO> listUserLabel(Long appletBookClassifyId);
    /**
     * 获取书刊分类列表及其标签
     * @author：zhuyajie
     * @date：2020/5/18 16:14
     *  * @param null
     */
    List<AppletBookClassifyDTO> getAllBookClassifyAndLabel(String grayStatus);

    /**
     * 查关联书刊分类
     * @author：zhuyajie
     * @date：2020/5/19 18:38
     *  * @param null
     */
    List<Long> getRelationBookTempletByBookClassify(Long bookClassifyId);

    /**
     * 查关联标签
     * @author：zhuyajie
     * @date：2020/5/19 18:38
     *  * @param null
     */
    List<AppletUserLabelRelation> getByAppletUserLabelId(Long appletUserLabelId);

    /**
     * 平台端获取二级分类
     * @author：zhuyajie
     * @date：2020/6/15 16:07
     *  * @param null
     */
    List<AssistTempletDTO> getChildTempletList(Long appletBookClassifyId);


    /**
     * 根据一级分类id获取书籍分类id
     * @param firstClassifyId
     * @return
     */
    Long getAppletBookClassifyId(Long firstClassifyId);

    Map<Long, AppletBookClassifyDTO> getBookClassifyByIds(List<Long> bookAdviserIds);
}
