package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.entity.AppletNewsServe;
import com.pcloud.book.applet.dao.AppletNewsServeDao;
import com.pcloud.book.applet.biz.AppletNewsServeBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * (AppletNewsServe)表服务实现类
 *
 * @author makejava
 * @since 2020-06-30 16:56:08
 */
@Service("appletNewsServeBiz")
public class AppletNewsServeBizImpl implements AppletNewsServeBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletNewsServeBizImpl.class);

    @Autowired
    private AppletNewsServeDao appletNewsServeDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletNewsServe getById(Long id) {
        return appletNewsServeDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletNewsServeDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletNewsServe appletNewsServe) {
        appletNewsServeDao.insert(appletNewsServe);
        return appletNewsServe.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletNewsServe appletNewsServe) {
        if(appletNewsServe == null || !NumberUtil.isNumber(appletNewsServe.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        appletNewsServeDao.update(appletNewsServe);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletNewsServeDao.deleteById(id);
    }
}