/**
 * 
 */
package com.pcloud.book.consumer.user;

import com.pcloud.channelcenter.base.exceptions.ChannelBizException;
import com.pcloud.channelcenter.qrcode.dto.MapResourceCountDTO;
import com.pcloud.channelcenter.qrcode.dto.QrcodeMessageDTO;
import com.pcloud.channelcenter.qrcode.service.QrcodeSceneService;
import com.pcloud.channelcenter.wechat.service.MessageService;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.usercenter.party.channel.service.ChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @描述：渠道用户中间类
 * @作者：songx
 * @创建时间：2016年11月17日,上午10:37:09 @版本：1.0
 */
@Component("channelConsr")
public class ChannelConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(ChannelConsr.class);

	@Autowired
	private ChannelService channelService;
	@Autowired
	private MessageService messageService;
	@Autowired
	private QrcodeSceneService qrcodeSceneService;

	/**
	 * 获取渠道名称
	 */
	public String getNameById(Long channelId) throws BizException {
		LOGGER.info("【渠道用户(消)】获取渠道名称,<START>.[channelId]=" + channelId);
		String channelName = "";
		if (channelId == null) {
			return channelName;
		}
		try {
			channelName = ResponseHandleUtil.parseResponse(channelService.getNameById(channelId), String.class);
		} catch (Exception e) {
			LOGGER.error("【渠道用户(消)】获取渠道名称,<ERROR>.[getNameById]:" + e.getMessage(), e);
		}
		return channelName;
	}

	/**
	 * 批量获取渠道名称
	 */
	public Map<Long, String> getNamesByIdList(List<Long> channelIds) throws BizException {
		LOGGER.info("【渠道用户(消)】量获取渠道名称,<START>.[channelIds]=" + channelIds.toString());
		if (ListUtils.isEmpty(channelIds)) {
			return null;
		}
		Map<Long, String> channelMap = null;
		try {
			channelMap = ResponseHandleUtil.parseMapResponse(channelService.getNamesByIdList(channelIds), Long.class,
					String.class);
		} catch (Exception e) {
			LOGGER.error("【渠道用户(消)】获取渠道信息,<ERROR>.[getNamesByIdList]:" + e.getMessage(), e);
		}
		return channelMap;
	}

	/**
	 * 获取代理标识
	 */
	public Long getParentId(Long channelId) throws BizException {
		LOGGER.info("【渠道用户(消)】获取代理标识,<START>.[channelId]=" + channelId);
		Long agentId = null;
		if (channelId == null) {
			return agentId;
		}
		try {
			agentId = ResponseHandleUtil.parseResponse(channelService.getParentId(channelId), Long.class);
		} catch (Exception e) {
			LOGGER.error("【渠道用户(消)】获取代理标识,<ERROR>.[getParentId]:" + e.getMessage(), e);
		}
		return agentId;
	}
	
	
	 /**
     * 验证编辑渠道是否为一个出版社
     */
    public Boolean judgeChannelAdviserRelationship(Long channelId, Long adviserId) throws BizException {
        LOGGER.info(" 验证编辑渠道是否为一个出版社,参数列表[channelId]:" + channelId + ",[adviserId]=" + adviserId);
        if (channelId == null || adviserId == null) {
            LOGGER.info("验证编辑渠道是否为一个出版社,参数为空");
            return false;
        }
        Boolean status = false;
        try {
            status = ResponseHandleUtil
                    .parseResponse(channelService.judgeChannelAdviserRelationship(channelId, adviserId), Boolean.class);
        } catch (BizException e) {
            LOGGER.warn("验证编辑渠道是否为一个出版社失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            LOGGER.error("验证编辑渠道是否为一个出版社失败:" + e.getMessage(), e);
            throw new ChannelBizException(ChannelBizException.INVOKE_USER_ERROR, "验证编辑渠道是否为一个出版社失败~!");
        }
        return status;
    }

	/**
	 * 获取代理下已经审核通过的运营id
	 * @param agentId
	 * @return
	 * @throws BizException
	 */
	public List<Long> getApproveIdList(Long agentId)throws BizException{
		LOGGER.info("获取代理下已经审核通过的运营id,<START>.[agentId]=" + agentId);
		try {
			return ResponseHandleUtil.parseListResponse(channelService.getApproveIdList(agentId),Long.class);
		} catch (Exception e) {
			LOGGER.error("获取代理下已经审核通过的运营id.[getApproveIdList]:" + e.getMessage(), e);
			throw new ChannelBizException(ChannelBizException.PARAM_IS_NULL, "运营不存在");
		}
	}

	/**
	 * 根据bookIds获取资源数
	 * @param bookIds
	 * @return
	 */
	public Integer getMessageCountByBookIds(List<Long> bookIds){
		LOGGER.info("根据bookIds获取资源数,<START>.[bookIds]=" + bookIds.toString());
		try {
			return ResponseHandleUtil.parseResponse(messageService.getMessageCountByBookIds(bookIds), Integer.class);
		} catch (Exception e) {
			LOGGER.error("获取代理下已经审核通过的运营id.[getApproveIdList]:" + e.getMessage(), e);
			throw new ChannelBizException(ChannelBizException.PARAM_IS_NULL, "运营不存在");
		}
	}

	public Long getBookId4SceneId(Long sceneId) {
		Long bookId = null;
		LOGGER.info("根据sceneId获取bookId,<START>.[sceneId]=" + sceneId);
		try {
			bookId = ResponseHandleUtil.parseResponse(qrcodeSceneService.getBookId4SceneId(sceneId), Long.class);
			if (null == bookId) {
				throw new ChannelBizException(ChannelBizException.PARAM_IS_NULL, "bookId为空");
			}
			return bookId;
		} catch (Exception e) {
			LOGGER.error("根据sceneId获取bookId" + e.getMessage(), e);
			throw new ChannelBizException(ChannelBizException.PARAM_IS_NULL, "bookId为空");
		}
	}

	public Map<String, QrcodeMessageDTO> mapResourceCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds) {
		MapResourceCountDTO mapResourceCountDTO = new MapResourceCountDTO();
		mapResourceCountDTO.setAdviserIds(adviserIds);
		mapResourceCountDTO.setBookIds(bookIds);
		mapResourceCountDTO.setChannelIds(channelIds);
		Map<String, QrcodeMessageDTO> mapQrcodeMessage = ResponseHandleUtil.parseMap(qrcodeSceneService.mapResourceCount(mapResourceCountDTO), String.class, QrcodeMessageDTO.class);
		return mapQrcodeMessage;
	}
}
