package com.pcloud.book.pcloudkeyword.biz;


import com.pcloud.book.pcloudkeyword.entity.PcloudKeyword;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.book.pcloudkeyword.entity.PcloudNotKeyword;

public interface PcloudKeywordBiz {

    void createPcloudKeyword(PcloudKeyword pcloudKeyword);

    void updatePcloudKeyword(PcloudKeyword pcloudKeyword);

    PcloudKeyword getPcloudKeyword(Long id);

    PageBeanNew<PcloudKeyword> getPcloudKeywordList(Long keywordClassifyId, String name, Integer currentPage, Integer numPerPage);

    void deletePcloudKeyword(Long id);
    /**
     * 新增非关键词回复
     * @return
     */
    Long insertNotKeyword(PcloudNotKeyword pcloudNotKeyword);
    /**
     * 修改费关键词
     */
    void updateNotKeyword(PcloudNotKeyword pcloudNotKeyword);

    /**
     * 删除非关键词
     * @param id
     */
    void deletePcloudNotKeyword(Long id);

    /**
     * 根据id查非关键词
     * @param id
     * @return
     */
    public PcloudNotKeyword getNotKeywordById(Long id);

    /**
     * 非关键词列表
     * @param keywordClassifyId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<PcloudNotKeyword> getPcloudNotKeywordList(Long keywordClassifyId, Integer currentPage, Integer numPerPage);

    /**
     * 根据分类删除关键词
     * @param id
     */
    void deleteByKeywordClassifyId(Long id);

    /**
     * 该技能是否被引用
     * @param skillId
     * @return
     */
    Boolean skillExist(Long skillId);
}
