package com.pcloud.book.push.dao;

import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.push.dto.PlanClassifyDTO;
import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:46
 **/
public interface PushGroupDao extends BaseDao<PushGroup> {
    /**
     * 批量插入
     */
    Integer batchInsert(List<PushGroup> pushGroups);

    /**
     * 根据pushId查询列表
     */
    List<PushGroup> getListByPushId(Long pushId);

    /**
     * 根据pushId删除
     * @param pushId
     * @param partyId
     */
    void deleteByPushId(Long pushId, Long partyId);

    /**
     * 批量删除
     * @param ids
     * @param partyId
     */
    void deleteByIds(List<Long> ids, Long partyId);

    /**
     * 根据群发id集合获取群发关联集合
     * @param pushIds
     * @return
     */
    List<PushGroup> getListByPushIds(List<Long> pushIds);

    /**
     * 根据群发计划id集合获取群发计划关联
     * @param pushPlanIds
     * @return
     */
    List<PlanClassifyDTO> getPlanClassifyListByPlanIds(List<Long> pushPlanIds);

    /**
     * 根据分类id查询
     * @param classifyId
     * @return
     */
    List<PushGroup> getListByClassifyId(Long classifyId);

    /**
     * 根据群发计划id获取群发计划关联
     * @param pushPlanId
     * @return
     */
    List<PlanClassifyDTO> getPlanClassifyListByPlanId(Long pushPlanId);

    /**
     * 获取所有应用作品类型的群发
     */
    List<BookGroupApp> getAllAppPush();
}
