package com.pcloud.book.push.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 15:41
 **/
@ApiModel("消息推送记录模型")
public class PushRecord extends BaseEntity {

    @ApiModelProperty("群发标识")
    private Long pushId;

    @ApiModelProperty("发送类型（1:立即发送 2:单次发送 3:每天发送）")
    private Integer pushType;

    @ApiModelProperty("发送时间")
    private Date pushTime;

    @ApiModelProperty("发送状态（1发送中 2发送成功 3发送失败 4部分成功）")
    private Integer pushStatus;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public String toString() {
        return "PushRecord{" +
                "pushId=" + pushId +
                ", pushType=" + pushType +
                ", pushTime=" + pushTime +
                ", pushStatus=" + pushStatus +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                "} " + super.toString();
    }
}
