package com.pcloud.book.timecontrol.mapper;


import com.pcloud.book.timecontrol.dto.BookTaskBindingDto;
import com.pcloud.book.timecontrol.dto.SubscribeTaskUserDTO;
import com.pcloud.book.timecontrol.dto.TaskCompletedDto;
import com.pcloud.book.timecontrol.dto.TaskDto;
import com.pcloud.book.timecontrol.entity.TimeControlTask;
import com.pcloud.book.timecontrol.vo.KeyWordTaskVO;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("taskMapper")
public interface TimeControlTaskMapper {

    int deleteByPrimaryKey(Integer taskId);

    int insert(TimeControlTask record);

    TimeControlTask selectByPrimaryKey(Integer taskId);

    void updateTask(TimeControlTask timeControlTask);

    Integer getTaskCount(@Param("search") String search);

    List<TaskDto> listTask4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage, @Param("search") String search);

    /**
     * 根据 专业/深度/目的 标签查询任务模板集合
     */
    List<Integer> listIdByLabelId(@Param("proLabelId") Integer proLabelId, @Param("depLabelId") Integer depLabelId, @Param("purLabelId") Integer purLabelId);

    List<BookTaskBindingDto> listTask(@Param("search") String search);

    @MapKey("taskId")
    Map<Integer, TaskDto> mapByIds(@Param("taskIds") List<Integer> taskIds);

    List<KeyWordTaskVO> listKeyWordTask();

    TaskDto getTaskByKey(String search);

    List<Long> listMaxDepLabel(Integer num);

    List<TaskDto> listTaskByKey4User(@Param("search") String search, @Param("taskIds") List<Long> taskIds);

    List<TaskDto> listTaskByIds(@Param("taskIds") List<Integer> taskIds);

    List<TaskDto> listTaskByLabelId(Long labelId);

    TaskDto getTaskByIdAndWxUserId(@Param("relSkillId")Integer relSkillId, @Param("wxUserId")String wxUserId);

    Integer getSubscribeState(@Param("relSkillId")Integer relSkillId, @Param("wxUserId")String wxUserId);

    Integer getTaskCompletedCount(@Param("taskName") String taskName,@Param("proLabelId") Integer proLabelId, @Param("depLabelId") Integer depLabelId, @Param("purLabelId") Integer purLabelId);

    List<TaskCompletedDto> listTaskCompleted4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage, @Param("taskName") String taskName, @Param("proLabelId") Integer proLabelId, @Param("depLabelId") Integer depLabelId, @Param("purLabelId") Integer purLabelId);

    Integer getSubscribeCount(@Param("search") String search,@Param("taskId") Integer taskId,@Param("subscribeType") Integer subscribeType,@Param("wxIds") List<String> wxIds);

    List<SubscribeTaskUserDTO> listTaskSubscribeUser4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage, @Param("search") String search, @Param("taskId") Integer taskId,@Param("subscribeType") Integer subscribeType,@Param("wxIds") List<String> wxIds);

    void updateTaskSendType(TimeControlTask taskDto);
}